//
// NAME: CIDTracer_NoiseTextures.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDTracer_NoiseTextures.Cpp module, which provides
//  the TTxtrNoise class and a number of simple derivatives of it.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 05/15/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TTxtrNoise
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrNoise : public TRTTexture
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrNoise();

        TTxtrNoise
        (
            const   TTxtrNoise&             txtrToCopy
        );

        ~TTxtrNoise() {}


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid ParseMethod
        (
                    TParseInfo&             prsiSource
        );


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrNoise& operator=
        (
            const   TTxtrNoise&             txtrToAssign
        );


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8 f8BumpAmount() const;

        tCIDLib::TFloat8 f8BumpAmount
        (
            const   tCIDLib::TFloat8        f8Val
        );

        tCIDLib::TFloat8 f8Frequency() const;

        tCIDLib::TFloat8 f8Frequency
        (
            const   tCIDLib::TFloat8        f8Val
        );

        tCIDLib::TFloat8 f8Phase() const;

        tCIDLib::TFloat8 f8Phase
        (
            const   tCIDLib::TFloat8        f8Val
        );

        tCIDLib::TFloat8 f8Turbulence() const;

        tCIDLib::TFloat8 f8Turbulence
        (
            const   tCIDLib::TFloat8        f8Val
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Declare our friend
        // ---------------------------------------------------------------------
        friend static tCIDLib::TVoid __InitTables();


        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


        // ---------------------------------------------------------------------
        //  Protected, static methods
        // ---------------------------------------------------------------------
        static tCIDLib::TFloat8 _f8Cycloidal
        (
            const   tCIDLib::TFloat8        f8Value
        );

        static tCIDLib::TFloat8 _f8Noise
        (
            const   tCIDLib::TFloat8        f8X
            , const tCIDLib::TFloat8        f8Y
            , const tCIDLib::TFloat8        f8Z
        );

        static tCIDLib::TFloat8 _f8Noise
        (
            const   T3DVector&              vecPos
        );

        static tCIDLib::TFloat8 _f8Turbulence
        (
            const   tCIDLib::TFloat8        f8X
            , const tCIDLib::TFloat8        f8Y
            , const tCIDLib::TFloat8        f8Z
        );

        static tCIDLib::TFloat8 _f8Turbulence
        (
            const   T3DVector&              vecPos
        );

        static tCIDLib::TFloat8 _f8TriangleWave
        (
            const   tCIDLib::TFloat8        f8Value
        );

        static tCIDLib::TVoid _VecNoise
        (
                    T3DVector&              vecTarget
            , const T3DVector&              vecPoint
        );

        static tCIDLib::TVoid _VecNoise
        (
                    T3DVector&              vecTarget
            , const tCIDLib::TFloat8        f8X
            , const tCIDLib::TFloat8        f8Y
            , const tCIDLib::TFloat8        f8Z
        );

        static tCIDLib::TVoid _VecTurbulence
        (
                    T3DVector&              vecTarget
            , const tCIDLib::TFloat8        f8X
            , const tCIDLib::TFloat8        f8Y
            , const tCIDLib::TFloat8        f8Z
        );


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __f8BumpAmount
        //      This value controls the extremity of surface normal
        //      perterbation in textures that adjust the surface normal.
        //
        //  __f8Frequency
        //      This is a control parameter for wave textures.
        //
        //  __f8Phase
        //      This is a control parameter for wave textures.
        //
        //  __f8TurbVal
        //      This is a turbulence value that can be applied to some
        //      textures. Some might not use it.
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8        __f8BumpAmount;
        tCIDLib::TFloat8        __f8Frequency;
        tCIDLib::TFloat8        __f8Phase;
        tCIDLib::TFloat8        __f8TurbVal;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrNoise,TRTTexture)
        DefPolyDup(TTxtrNoise)
};



// -----------------------------------------------------------------------------
//  CLASS: TTxtrBumps
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrBumps : public TTxtrNoise
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrBumps();

        TTxtrBumps
        (
            const   TTxtrBumps&             txtrToCopy
        );

        ~TTxtrBumps() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrBumps& operator=
        (
            const   TTxtrBumps&             txtrToAssign
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean bAdjustNormalAt
        (
            const   T3DVector&              vecPoint
            ,       T3DVector&              vecNormal
        )   const;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrBumps,TTxtrNoise)
        DefPolyDup(TTxtrBumps)
};



// -----------------------------------------------------------------------------
//  CLASS: TTxtrDents
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrDents : public TTxtrNoise
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrDents();

        TTxtrDents
        (
            const   TTxtrDents&             txtrToCopy
        );

        ~TTxtrDents() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrDents& operator=
        (
            const   TTxtrDents&             txtrToAssign
        );



        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean bAdjustNormalAt
        (
            const   T3DVector&              vecPoint
            ,       T3DVector&              vecNormal
        )   const;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrDents,TTxtrNoise)
        DefPolyDup(TTxtrDents)
};



// -----------------------------------------------------------------------------
//  CLASS: TTxtrWaves
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrWaves : public TTxtrNoise
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrWaves();

        TTxtrWaves
        (
            const   TTxtrWaves&             txtrToCopy
        );

        ~TTxtrWaves() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrWaves& operator=
        (
            const   TTxtrWaves&             txtrToAssign
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean bAdjustNormalAt
        (
            const   T3DVector&              vecPoint
            ,       T3DVector&              vecNormal
        )   const;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrWaves,TTxtrNoise)
        DefPolyDup(TTxtrWaves)
};



// -----------------------------------------------------------------------------
//  CLASS: TTxtrWrinkles
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrWrinkles : public TTxtrNoise
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrWrinkles();

        TTxtrWrinkles
        (
            const   TTxtrWrinkles&          txtrToCopy
        );

        ~TTxtrWrinkles() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrWrinkles& operator=
        (
            const   TTxtrWrinkles&          txtrToAssign
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean bAdjustNormalAt
        (
            const   T3DVector&              vecPoint
            ,       T3DVector&              vecNormal
        )   const;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrWrinkles,TTxtrNoise)
        DefPolyDup(TTxtrWrinkles)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  TTxtrNoise: Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TFloat8 TTxtrNoise::f8BumpAmount() const
{
    return __f8BumpAmount;
}

inline tCIDLib::TFloat8
TTxtrNoise::f8BumpAmount(const tCIDLib::TFloat8 f8Val)
{
    __f8BumpAmount = f8Val;
    return f8Val;
}

inline tCIDLib::TFloat8 TTxtrNoise::f8Frequency() const
{
    return __f8Frequency;
}

inline tCIDLib::TFloat8
TTxtrNoise::f8Frequency(const tCIDLib::TFloat8 f8Val)
{
    __f8Frequency = f8Val;
    return __f8Frequency;
}

inline tCIDLib::TFloat8 TTxtrNoise::f8Phase() const
{
    return __f8Phase;
}

inline tCIDLib::TFloat8 TTxtrNoise::f8Phase(const tCIDLib::TFloat8 f8Val)
{
    __f8Phase = f8Val;
    return __f8Phase;
}

inline tCIDLib::TFloat8 TTxtrNoise::f8Turbulence() const
{
    return __f8TurbVal;
}

inline tCIDLib::TFloat8 TTxtrNoise::f8Turbulence(const tCIDLib::TFloat8 f8Val)
{
    __f8TurbVal = f8Val;
    return f8Val;
}
