//
// NAME: CIDTracer_MetaObj.Hpp
//
// DESCRIPTION: 
//
//  This is the header file for the CIDTracer_MetaObj.Cpp module. This module
//  implements the TRTMetaObj class, which is the basis for all of the
//  'object container' classes. Objects of these classes are not directly
//  visible, instead they contain other objects and control them as a whole.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/01/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TRTMetaObj
// PREFIX: meta
// -----------------------------------------------------------------------------
class CIDTRACEREXP TRTMetaObj : public TRTObject
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TRTMetaObj();

        TRTMetaObj
        (
            const   TRTMetaObj&             metaSrc
        );

        ~TRTMetaObj();


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TRTMetaObj& operator=
        (
            const   TRTMetaObj&             metaSrc
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid AppendTexture
        (
                    TRTTexture* const       ptxtrAppend
            , const TString&                strName = NUL_TString
            , const TString&                strNameSpace = NUL_TString
        );

        tCIDLib::TVoid Invert();

        tCIDLib::TVoid ParseMethod
        (
                    TParseInfo&             prsiSource
        );

        tCIDLib::TVoid PrependTexture
        (
                    TRTTexture* const       ptxtrPrepend
            , const TString&                strName = NUL_TString
            , const TString&                strNameSpace = NUL_TString
        );

        tCIDLib::TVoid Transform
        (
            const   TTransform&             trnsApply
        );

        tCIDLib::TVoid TransformTextures
        (
            const   TTransform&             trnsTrans
        );


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid AdoptChild
        (
                    TRTObject* const        prtobjNew
            , const TString&                strName = NUL_TString
            , const TString&                strNameSpace = NUL_TString
        );

        const TRTObjList& rtlstChildren() const;


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _AllIntersects
        (
            const   TLightRay&              lrayTest
            ,       TIntersectArray&        intraIntersects
        )   const;

        tCIDLib::TBoolean _bPointInObj
        (
            const   T3DVector&              vecPoint
        )   const;

        tCIDLib::TBoolean _bTestIntersect
        (
            const   TLightRay&              lrayTest
            ,       tCIDLib::TFloat8&       f8Distance1
            ,       tCIDLib::TFloat8&       f8Distance2
        )   const;
    
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _Rotate
        (
            const   T3DVector&              vecRotate
            , const TTransform&             trnsRotate
        );

        tCIDLib::TVoid _Scale
        (
            const   T3DVector&              vecScale
            , const TTransform&             trnsScale
        );

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;

        tCIDLib::TVoid _Translate
        (
            const   T3DVector&              vecTrans
            , const TTransform&             trnsTranslate
        );


    private :
        // ---------------------------------------------------------------------
        //  Private, virtual methods
        // ---------------------------------------------------------------------
        virtual tCIDLib::TVoid __NewObject
        (
                    TRTObject* const        prtobjNew
            , const tCIDLib::TCard4         c4ObjCount
        );


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __prtlstChildren
        //      This is the list of child objects.
        // ---------------------------------------------------------------------
        TRTObjList*     __prtlstChildren;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TRTMetaObj,TRTObject)
        DefPolyDup(TRTMetaObj)
};

#pragma pack(pop)



// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline const TRTObjList& TRTMetaObj::rtlstChildren() const
{
    return *__prtlstChildren;
}


// -----------------------------------------------------------------------------
//  Private, virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TVoid
TRTMetaObj::__NewObject(        TRTObject* const    prtobjNew
                        , const tCIDLib::TCard4     c4ObjCount)
{
}
