//
// NAME: CIDRay_Intersect.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDRay_Intersect.Cpp module. This module
//  implements the TInsertsect and TInsertArray classes. These classes
//  are used heavily by the ray tracer kernel when finding all of the
//  objects which are intersected by a particular ray.
//
//  TIntersect represents an intersection of a light ray with an object
//  and the distance from the ray origin to that intersection. It has
//  such super high performance needs that it has public members. This
//  is very much an unusual thing, but worth it here. There can be
//  derivatives of this class for very complex or specialized objects.
//  Since each object is asked to find its intersections, it can put
//  whatever type of intersection object it wants into the list.
//
//  TIntersectArray is a very specialized container (not derived from the
//  standard container classes) for holding the intersect objects from hit
//  testing. It has to be very quickly sortable and efficient since this
//  operation is done many many times during a rendering session. It is
//  implemented as an expandable array of pointers to basic TIntersect
//  objects (though they might be actually derived classes.)
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 10/23/95
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// -----------------------------------------------------------------------------
//  Forward references
// -----------------------------------------------------------------------------
class   TLightRay;
class   TRTGeometricObj;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TIntersect
// PREFIX: intr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TIntersect : public TObject, public MDuplicable
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TIntersect
        (
            const   TLightRay&              lrayTest
            , const TRTGeometricObj* const  prtobjIntersect
            , const tCIDLib::TFloat8        f8Dist
        );

        TIntersect
        (
            const   TIntersect&             intrSrc
        );

        ~TIntersect() {}


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        TIntersect& operator=
        (
            const   TIntersect&             intrSrc
        );


        // --------------------------------------------------------------------
        //  Public, data members
        // --------------------------------------------------------------------
        tCIDLib::TFloat8        f8Distance;
        const TRTGeometricObj*  prtobjInter;
        T3DVector               vecIntersect;


    protected   :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::ESortComps _eSortComp
        (
            const   TObject&                objTarget
        )   const;


    private  :
        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TIntersect,TObject)
        DefPolyDup(TIntersect)
};



// -----------------------------------------------------------------------------
//  CLASS: TIntersectArray
// PREFIX: intra
// -----------------------------------------------------------------------------
class CIDTRACEREXP TIntersectArray : public TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TIntersectArray();

        ~TIntersectArray();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        TIntersect* operator[]
        (
            const   tCIDLib::TCard4         c4Index
        );


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid Add
        (
                    TIntersect* const       pintrToAdd
        );

        tCIDLib::TCard4 c4ElemCount() const;

        tCIDLib::TCard4 c4HitCount() const;

        tCIDLib::TVoid Flush();

        tCIDLib::TVoid Sort();


    private :
        // --------------------------------------------------------------------
        //  Private, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid __FreeArray();

        tCIDLib::TVoid __AllocArray();
        

        // --------------------------------------------------------------------
        //  Private data members
        // --------------------------------------------------------------------
        tCIDLib::TCard4         __c4CacheEntry;
        tCIDLib::TCard4         __c4CurHits;
        tCIDLib::TCard4         __c4Elements;
        TIntersect**            __papintrHits;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TIntersectArray,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TCard4 TIntersectArray::c4ElemCount() const
{
    return __c4Elements;
}

inline tCIDLib::TCard4 TIntersectArray::c4HitCount() const
{
    return __c4CurHits;
}
