//
// NAME: CIDTracer_CSG.Hpp
//
// DESCRIPTION: 
//
//  This module implements the TRTSolidGeom class. This class is a constructive
//  solid geometry object. A CSG object is formed by the 'bitwise'
//  combination of two geometry objects. We support the intersection (AND),
//  union (OR), and difference (XOR) operations.
//
//  TRTSolidGeom is derived from the TRTMetaObj class, which provides us with
//  the capabilities to manage a list of child objects.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/02/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TRTSolidGeom
// PREFIX: csg
// -----------------------------------------------------------------------------
class CIDTRACEREXP TRTSolidGeom : public TRTMetaObj
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TRTSolidGeom();

        TRTSolidGeom
        (
            const   TRTSolidGeom&           csgSrc
        );

        ~TRTSolidGeom();


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid Invert();

        tCIDLib::TVoid ParseMethod
        (
                    TParseInfo&             prsiSource
        );

        // ---------------------------------------------------------------------
        //  Public public operators
        // ---------------------------------------------------------------------
        TRTSolidGeom& operator=
        (
            const   TRTSolidGeom&           csgSrc
        );


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDTracer::ECSGOps eOperation() const;

        tCIDTracer::ECSGOps eOperation
        (
            const   tCIDTracer::ECSGOps        eOperation
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, virtual methods
        // ---------------------------------------------------------------------
        virtual tCIDLib::TVoid _AllIntersects
        (
            const   TLightRay&              lrayTest
            ,       TIntersectArray&        intraIntersects
        )   const;

        virtual tCIDLib::TBoolean _bPointInObj
        (
            const   T3DVector&              vecPoint
        )   const;

        virtual tCIDLib::TBoolean _bTestIntersect
        (
            const   TLightRay&              lrayTest
            ,       tCIDLib::TFloat8&       f8Dist1
            ,       tCIDLib::TFloat8&       f8Dist2
        )   const;

        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


    private :
        // ---------------------------------------------------------------------
        //  Private, virtual methods
        // ---------------------------------------------------------------------
        virtual tCIDLib::TVoid __NewObject
        (
                    TRTObject* const        prtobjNew
            , const tCIDLib::TCard4         c4ObjCount
        );

        // ---------------------------------------------------------------------
        //  Private, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean __bIntersectTest
        (
            const   TRTGeometricObj* const  prtobjSkip
            , const T3DVector&               vecTest
        )   const;


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __eOperation
        //      This is the operation to apply to the objects. All child
        //      objects are applied using the same rules.
        // ---------------------------------------------------------------------
        tCIDTracer::ECSGOps        __eOperation;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TRTSolidGeom,TRTMetaObj)
        DefPolyDup(TRTSolidGeom)
};

#pragma pack(pop)



// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDTracer::ECSGOps TRTSolidGeom::eOperation() const
{
    return __eOperation;
}

inline tCIDTracer::ECSGOps
TRTSolidGeom::eOperation(const tCIDTracer::ECSGOps eOperation)
{
    __eOperation = eOperation;
    return eOperation;
}
