//
// NAME: CIDTracer_Box.Hpp
//
// DESCRIPTION: 
//
//  This is the header file for the CIDTracer_Box.Cpp module. This module
//  implements the TRTBox class, which is a very specialized CSG object.
//  The user can create CSG boxes, but this one will be much more
//  efficient. It stores 6 normal vectors and 6 distances, one for each
//  side of the box.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 07/21/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TBoxIntersect
// PREFIX: intr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TBoxIntersect : public TIntersect
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TBoxIntersect
        (
            const   TLightRay&              lrayTest
            , const TRTGeometricObj* const  prtobjIntersect
            , const tCIDLib::TFloat8        f8Dist
            , const tCIDLib::TCard4         c4PlaneIndex
        );

        TBoxIntersect
        (
            const   TBoxIntersect&          intrSrc
        );

        ~TBoxIntersect() {}


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        TBoxIntersect& operator=
        (
            const   TBoxIntersect&          intrSrc
        );

        // --------------------------------------------------------------------
        //  Public, data members
        //
        //  c4PlaneInd
        //      This is the index of the plane that was intersected.
        // --------------------------------------------------------------------
        tCIDLib::TCard4         c4PlaneInd;


    private :
        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TBoxIntersect,TIntersect)
        DefPolyDup(TBoxIntersect)
};



// -----------------------------------------------------------------------------
//  CLASS: TRTBox
// PREFIX: box
// -----------------------------------------------------------------------------
class CIDTRACEREXP TRTBox : public TRTGeometricObj
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        //
        //  TRTBox
        //      The default constructor creates a unit box, centered on the
        //      origin.
        //
        //  ~TRTBox
        //      Handles any needed cleanup.
        // ---------------------------------------------------------------------
        TRTBox();

        TRTBox
        (
            const   TRTBox&                 boxSrc
        );

        ~TRTBox() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TRTBox& operator=
        (
            const   TRTBox&                 boxSrc
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid CalcSurfaceNormal
        (
            const   TIntersect* const       pintrSrc
            ,       T3DVector&              vecNormal
        )   const;

        tCIDLib::TVoid Invert();

        tCIDLib::TVoid Transform
        (
            const   TTransform&             trnsApply
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _AllIntersects
        (
            const   TLightRay&              lrayTest
            ,       TIntersectArray&        intraIntersects
        )   const;

        tCIDLib::TBoolean _bPointInObj
        (
            const   T3DVector&              vecPoint
        )   const;

        tCIDLib::TBoolean _bTestIntersect
        (
            const   TLightRay&              lrayTest
            ,       tCIDLib::TFloat8&       f8Dist1
            ,       tCIDLib::TFloat8&       f8Dist2
        )   const;

        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _Rotate
        (
            const   T3DVector&              vecRotate
            , const TTransform&             trnsRotate
        );

        tCIDLib::TVoid _Scale
        (
            const   T3DVector&              vecScale
            , const TTransform&             trnsScale
        );

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;

        tCIDLib::TVoid _Translate
        (
            const   T3DVector&              vecTrans
            , const TTransform&             trnsTranslate
        );


    private :
        // ---------------------------------------------------------------------
        //  Private class constants
        // ---------------------------------------------------------------------
        enum    ePrivateBoxConstants
        {
            c4PlaneCount        = 6
        };


        // ---------------------------------------------------------------------
        //  Private, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean __bTestIntersect
        (
            const   TLightRay&              lrayTest
            , const tCIDLib::TCard4         c4Ind
            ,       tCIDLib::TFloat8&       f8Dist1
        )   const;


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __af8Distances
        //      The distance from the space origin for each plane.
        //
        //  __avecNormals
        //      The vectors that represent the planes' normals, i.e. a ray
        //      sticking straight up out of each plane.
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8    __af8Distances[c4PlaneCount];
        T3DVector           __avecNormals[c4PlaneCount];


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TRTBox,TRTGeometricObj)
        DefPolyDup(TRTBox)
};

#pragma pack(pop)
