//
// NAME: CIDTracer_BaseTextures.Hpp
//
// DESCRIPTION: 
//
//  This is the header file for the CIDTracer_BaseTextures.Cpp module. This
//  module implements a few of the most basic procedural textures such as
//  checker boards.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 05/08/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TTxtrChecker
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrChecker : public TRTTexture
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrChecker
        (
            const   TFRGBClr&               frgbClr
            , const TFRGBClr&               frgbClr2
        );

        TTxtrChecker();

        TTxtrChecker
        (
            const   TTxtrChecker&           txtrToCopy
        );

        ~TTxtrChecker()  {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrChecker& operator=
        (
            const   TTxtrChecker&           txtrToAssign
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid QueryColorAt
        (
            const   T3DVector&              vecPoint
            ,       TFRGBClr&               frgbClr
        )   const;

        tCIDLib::TVoid ParseMethod
        (
                    TParseInfo&             prsiSource
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


    private     :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __frgbClr2
        //      This is the alternate color that is used in conjuntion with
        //      the basic color to create the checkers.
        // ---------------------------------------------------------------------
        TFRGBClr        __frgbClr2;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrChecker,TRTTexture)
        DefPolyDup(TTxtrChecker)
};



// -----------------------------------------------------------------------------
//  CLASS: TTxtrStripe
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrStripe : public TRTTexture
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrStripe();

        TTxtrStripe
        (
            const   TFRGBClr&               frgbClr
            , const TFRGBClr&               frgbClr2
        );

        TTxtrStripe
        (
            const   TTxtrStripe&            txtrToCopy
        );

        ~TTxtrStripe()  {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrStripe& operator=
        (
            const   TTxtrStripe&            txtrToAssign
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean bAdjustNormalAt
        (
            const   T3DVector&               vecPoint
            ,       T3DVector&               vecNormal
        )   const   {return kCIDLib::False;}

        tCIDLib::TVoid ParseMethod
        (
                    TParseInfo&             prsiSource
        );

        tCIDLib::TVoid QueryColorAt
        (
            const   T3DVector&               vecPoint
            ,       TFRGBClr&               frgbClr
        )   const;


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __frgbClr2
        //      This is the second color, which is used in conjunction with
        //      the basic texture color to create the stripes.
        // ---------------------------------------------------------------------
        TFRGBClr        __frgbClr2;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrStripe,TRTTexture)
        DefPolyDup(TTxtrStripe)
};

#pragma pack(pop)
