//
// NAME: CIDTracer_BandedTextures.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDTracer_BandedTextures.Cpp module, which
//  defines the TTxtrBanded class and a number of small derivatives. Banded
//  textures are derived from TTxtrNoise and use the noise value to choose
//  one of a number of bands of color. Each band is a lower and upper noise
//  value that is used to map a noise to a band. Each band also has an upper
//  and lower color. The relative position of the noise between the up/low
//  range is used to interpolate the color.
//
//  The banded class provides a couple of virtual methods that allow
//  derived classes to control the calculation of the noise value and
//  the interpolatio of the color.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/30/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TTxtrBanded
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrBanded : public TTxtrNoise
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrBanded();

        TTxtrBanded
        (
            const   TTxtrBanded&            txtrSrc
        );

        ~TTxtrBanded();


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrBanded& operator=
        (
            const   TTxtrBanded&            txtrSrc
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid QueryColorAt
        (
            const   T3DVector&               vecPoint
            ,       TFRGBClr&               frgbClr
        )   const;

        tCIDLib::TVoid ParseMethod
        (
                    TParseInfo&             prsiSource
        );


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid AppendBand
        (
            const   tCIDLib::TFloat8        f8StartVal
            , const tCIDLib::TFloat8        f8EndVal
            , const TFRGBClr&               frgbStartClr
            , const TFRGBClr&               frgbEndClr
        );

        tCIDLib::TVoid PrependBand
        (
            const   tCIDLib::TFloat8        f8StartVal
            , const tCIDLib::TFloat8        f8EndVal
            , const TFRGBClr&               frgbStartClr
            , const TFRGBClr&               frgbEndClr
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


        // ---------------------------------------------------------------------
        //  Protected, virtual methods
        // ---------------------------------------------------------------------
        virtual tCIDLib::TFloat8 _f8CalcNoise
        (
            const   T3DVector&               vecPoint
        )   const;

        virtual tCIDLib::TVoid _CalcDefColor
        (
            const   tCIDLib::TFloat8        f8Noise
            ,       TFRGBClr&               frgbClr
        )   const;


        // ---------------------------------------------------------------------
        //  Protected, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _CalcBandColor
        (
            const   tCIDLib::TFloat8        f8NoiseVal
            , const tCIDLib::TFloat8        f8StartVal
            , const tCIDLib::TFloat8        f8EndVal
            , const TFRGBClr&               frgbStartClr
            , const TFRGBClr&               frgbEndClr
            ,       TFRGBClr&               frgbResult
        )   const;


    private     :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __prtlstBands
        //      This is a list used to store the list of color map items
        //      which define the bands of color.
        // ---------------------------------------------------------------------
        TRTBandList*    __prtlstBands;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrBanded,TTxtrNoise)
        DefPolyDup(TTxtrBanded)
};


// -----------------------------------------------------------------------------
//  CLASS: TTxtrAgate
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrAgate : public TTxtrBanded
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrAgate();

        TTxtrAgate
        (
            const   TTxtrAgate&             txtrToCopy
        );

        ~TTxtrAgate() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrAgate& operator=
        (
            const   TTxtrAgate&             txtrToAssign
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8 _f8CalcNoise
        (
            const   T3DVector&               vecPoint
        )   const;

        tCIDLib::TVoid _CalcDefColor
        (
            const   tCIDLib::TFloat8        f8Noise
            ,       TFRGBClr&               frgbClr
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrAgate,TTxtrBanded)
        DefPolyDup(TTxtrAgate)
};



// -----------------------------------------------------------------------------
//  CLASS: TTxtrGranite
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrGranite : public TTxtrBanded
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrGranite();

        TTxtrGranite
        (
            const   TTxtrGranite&           txtrSrc
        );

        ~TTxtrGranite() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrGranite& operator=
        (
            const   TTxtrGranite&           ttxtrToAssign
        );

    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8 _f8CalcNoise
        (
            const   T3DVector&               vecPoint
        )   const;

        tCIDLib::TVoid _CalcDefColor
        (
            const   tCIDLib::TFloat8        f8Noise
            ,       TFRGBClr&               frgbClr
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrGranite,TTxtrBanded)
        DefPolyDup(TTxtrGranite)
};



// -----------------------------------------------------------------------------
//  CLASS: TTxtrMarble
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrMarble : public TTxtrBanded
{
    public              :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrMarble();

        TTxtrMarble
        (
            const   TTxtrMarble&            txtrToCopy
        );

        ~TTxtrMarble() {}



        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrMarble& operator=
        (
            const   TTxtrMarble&            txtrToAssign
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8 _f8CalcNoise
        (
            const   T3DVector&               vecPoint
        )   const;

        tCIDLib::TVoid _CalcDefColor
        (
            const   tCIDLib::TFloat8        f8Noise
            ,       TFRGBClr&               frgbClr
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrMarble,TTxtrBanded)
        DefPolyDup(TTxtrMarble)
};



// -----------------------------------------------------------------------------
//  CLASS: TTxtrSpots
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrSpots : public TTxtrBanded
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrSpots();

        TTxtrSpots
        (
            const   TTxtrSpots&             txtrToCopy
        );

        ~TTxtrSpots() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrSpots& operator=
        (
            const   TTxtrSpots&             txtrToAssign
        );


    private :
        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrSpots,TTxtrBanded)
        DefPolyDup(TTxtrSpots)
};



// -----------------------------------------------------------------------------
//  CLASS: TTxtrWood
// PREFIX: txtr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTxtrWood : public TTxtrBanded
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTxtrWood();

        TTxtrWood
        (
            const   TTxtrWood&              txtrToCopy
        );

        ~TTxtrWood() {}



        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TTxtrWood& operator=
        (
            const   TTxtrWood&              txtrToAssign
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8 _f8CalcNoise
        (
            const   T3DVector&              vecPoint
        )   const;

        tCIDLib::TVoid _CalcDefColor
        (
            const   tCIDLib::TFloat8        f8Noise
            ,       TFRGBClr&               frgbClr
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTxtrWood,TTxtrBanded)
        DefPolyDup(TTxtrWood)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  TTxtrBanded: Protected, virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TFloat8
TTxtrBanded::_f8CalcNoise(const T3DVector& vecPoint) const
{
    return _f8Noise(vecPoint);
}

inline tCIDLib::TVoid
TTxtrBanded::_CalcDefColor( const   tCIDLib::TFloat8    f8Noise
                            ,       TFRGBClr&           frgbClr) const
{
    frgbClr += f8Noise;
}
