//
// NAME: CIDTracer_BandedItem.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDTracer_BandedItem.Cpp module, which
//  defines the TBandItem class. This is a class used by the banded
//  textures. It has to be in a separate header because it is one of the
//  classes for which an TRTList<> template instantiation is done. So
//  putting in a separate file avoids a header inclusion problem.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/30/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TBandItem
// PREFIX: band
// -----------------------------------------------------------------------------
class CIDTRACEREXP TBandItem :

    public TObject, public MDuplicable, public MStreamable
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TBandItem();

        TBandItem
        (
            const   tCIDLib::TFloat8        f8End
            , const tCIDLib::TFloat8        f8Start
            , const TFRGBClr&               frgbEnd
            , const TFRGBClr&               frgbStart
        );

        TBandItem
        (
            const   TBandItem&              bandSrc
        );

        ~TBandItem() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean operator==
        (
            const   TBandItem&              bandToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TBandItem&              bandToTest
        )   const;

        tCIDLib::TVoid operator=
        (
            const   TBandItem&              bandToTest
        );


        // ---------------------------------------------------------------------
        //  Public data members
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8        f8EndVal;
        tCIDLib::TFloat8        f8StartVal;
        TFRGBClr                frgbEndClr;
        TFRGBClr                frgbStartClr;


   protected   :
        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TBandItem,TObject)
        DefPolyDup(TBandItem)
};

#pragma pack(pop)



// -----------------------------------------------------------------------------
//  Public operators
// -----------------------------------------------------------------------------
inline tCIDLib::TBoolean
TBandItem::operator!=(const TBandItem& bandToTest) const
{
    return !operator==(bandToTest);
}


// -----------------------------------------------------------------------------
//  Generate a list of band items
// -----------------------------------------------------------------------------
typedef TRTListNode<TBandItem>      TRTBandNode;
typedef TRTList<TBandItem>          TRTBandList;
