//
//  FILE NAME: CIDTracer_.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/23/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main internal header for the facility. It includes the main
//  public header, and any internal ones that are needed. It also includes
//  the system headers, which are only used internally.
//
//  CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Include our own public header
// ----------------------------------------------------------------------------
#include    "CIDTracer.Hpp"


// ----------------------------------------------------------------------------
//  Includde any internal headers
// ----------------------------------------------------------------------------
#include    "CIDTracer_MessageIds.Hpp"


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDTracer.Cpp
// ----------------------------------------------------------------------------
extern TMetricGroup*    _pmtrgTracerCore;


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDTracer_NoiseTextures.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermNoiseTextures
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);
extern tCIDLib::TCard2 _c2Random3D
(
    const   tCIDLib::TInt2 i2X
    , const tCIDLib::TInt2 i2Y
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDTracer_Parser.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermParser
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Namespace for internal non-class types.
// ----------------------------------------------------------------------------
namespace tCIDTracer_
{
    // ------------------------------------------------------------------------
    //  These are the indexes for the CIDRay core metrics. These must be
    //  contiguous since they are used ot index an array of metrics
    //  structures.
    //
    //  ActiveScenes
    //      The count of scenes currently being traced.
    //
    //  IntersectPages
    //      The number of pages of memory in use by the TIntersectArray
    //      class.
    // ------------------------------------------------------------------------
    enum eCoreMetrics
    {
        eCorEMetric_ActiveScenes
        , eCorEMetric_IntersectPages

        // This one MUST be last!!!
        , eCorEMetric_Count
    };
};


// ----------------------------------------------------------------------------
//  Namespace for internal constants
// ----------------------------------------------------------------------------
namespace kCIDTracer_
{
    // ------------------------------------------------------------------------
    //  Mathematical constants for use in ray tracing calculations.
    // ------------------------------------------------------------------------
    const tCIDLib::TFloat8  f8Epsilon           = 1e-03;
    const tCIDLib::TFloat8  f8TinyValue         = 1.0e-8;
    const tCIDLib::TFloat8  f8MaxDistance       = 1.0e7;
    const tCIDLib::TFloat8  f8SmallTolerance    = 0.001;


    // ------------------------------------------------------------------------
    //  These are strings used in emergency popups for this facility. These
    //  are overridden during DLL init with resource based strings. But, if
    //  that fails, these are the defaults.
    // ------------------------------------------------------------------------
    const tCIDLib::Tch* const pszTitle1         = L"CIDLib Ray Tracer";
    const tCIDLib::Tch* const pszTitle2         = L"Copyright (c) CIDLib 1992..1997";
};


// ----------------------------------------------------------------------------
//  Macros to aid with error popups
// ----------------------------------------------------------------------------
#define _ERRPOPUP_(meth,msg,err) \
TFacCIDLib::PopUpErr \
( \
    __FILE__ \
    , meth \
    , __LINE__ \
    , kCIDTracer_::pszTitle1 \
    , kCIDTracer_::pszTitle2 \
    , msg \
    , kCIDLib::pszEmptyZStr \
    , err \
    , tCIDLib::ERadix_Dec \
);

#define _MSGPOPUP_(meth,msg) \
TFacCIDLib::PopUpMsg \
( \
    __FILE__ \
    , meth \
    , __LINE__ \
    , kCIDTracer_::pszTitle1 \
    , kCIDTracer_::pszTitle2 \
    , msg \
    , kCIDLib::pszEmptyZStr \
);
