//
//  FILE NAME: CIDTracer.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/23/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main public header for the facility. It is the single point
//  of contact for the outside world. By including it, they get what we
//  have to offer. It also insures consistent order of inclusion which
//  is needed for the precompiled headers stuff to work.
//
//  CAVEATS/GOTCHAS:
//

#if         !defined(_CIDTRACER_)
#define     _CIDTRACER_

// ----------------------------------------------------------------------------
//  Set up our import/export attributes
// ----------------------------------------------------------------------------
#if     defined(PROJ_CIDTRACER)
#define CIDTRACEREXP    DLLEXPORT
#else
#define CIDTRACEREXP    DLLIMPORT
#endif


// ----------------------------------------------------------------------------
//  Include our underlying headers
// ----------------------------------------------------------------------------
#include    "CIDLib.Hpp"


// -----------------------------------------------------------------------------
//  Define nul references for the forward referenced classes.
// -----------------------------------------------------------------------------
#define NUL_TBandItem       (*(TBandItem*)0)
#define NUL_TBoxIntersect   (*(TBoxIntersect*)0)
#define NUL_TIntersect      (*(TIntersect*)0)
#define NUL_TIntersectArray (*(TIntersectArray*)0)
#define NUL_TLightRay       (*(TLightRay*)0)
#define NUL_TLightSource    (*(TLightSource*)0)
#define NUL_TParseInfo      (*(TParseInfo*)0)
#define NUL_TRTObject       (*(TRTObject*)0)
#define NUL_TRTBox          (*(TRTBox*)0)
#define NUL_TRTGeometricObj (*(TRTGeometricObj*)0)
#define NUL_TRTMetaObj      (*(TRTMetaObj*)0)
#define NUL_TRTPlane        (*(TRTPlane*)0)
#define NUL_TRTQuadric      (*(TRTQuadric*)0)
#define NUL_TRTSolidGeom    (*(TRTSolidGeom*)0)
#define NUL_TRTSphere       (*(TRTSphere*)0)
#define NUL_TTransform      (*(TTransform*)0)
#define NUL_TRTTexture      (*(TRTTexture*)0)
#define NUL_TTxtrAgate      (*(TTxtrAgate*)0)
#define NUL_TTxtrBanded     (*(TTxtrBanded*)0)
#define NUL_TTxtrBumps      (*(TTxtrBumps*)0)
#define NUL_TTxtrChecker    (*(TTxtrChecker*)0)
#define NUL_TTxtrDents      (*(TTxtrDents*)0)
#define NUL_TTxtrGranite    (*(TTxtrGranite*)0)
#define NUL_TTxtrMarble     (*(TTxtrMarble*)0)
#define NUL_TTxtrNoise      (*(TTxtrNoise*)0)
#define NUL_TTxtrSpots      (*(TTxtrSpots*)0)
#define NUL_TTxtrStripe     (*(TTxtrStripe*)0)
#define NUL_TTxtrWaves      (*(TTxtrWaves*)0)
#define NUL_TTxtrWood       (*(TTxtrWood*)0)
#define NUL_TTxtrWrinkles   (*(TTxtrWrinkles)0)
#define NUL_TViewGeometry   (*(TViewGeometry*)0)


// ----------------------------------------------------------------------------
//  Now subinclude our other headers, in the needed order.
// ----------------------------------------------------------------------------
#include    "CIDTracer_ResourceIds.H"
#include    "CIDTracer_ErrorIds.Hpp"
#include    "CIDTracer_Type.Hpp"
#include    "CIDTracer_Constants.Hpp"

// ----------------------------------------------------------------------------
//  <TBD> A hack to get around a problem in VC++ 5.0. Remove it when the
//  problem is fixed.
// ----------------------------------------------------------------------------
using namespace tCIDTracer;
using namespace kCIDTracer;

#include    "CIDTracer_ThisFac.Hpp"
#include    "CIDTracer_Transform.Hpp"
#include    "CIDTracer_List_.Hpp"
#include    "CIDTracer_Intersect.Hpp"
#include    "CIDTracer_Texture.Hpp"
#include    "CIDTracer_Object.Hpp"
#include    "CIDTracer_MetaObj.Hpp"
#include    "CIDTracer_Parse.Hpp"

#include    "CIDTracer_BandItem.Hpp"
#include    "CIDTracer_BaseTextures.Hpp"
#include    "CIDTracer_NoiseTextures.Hpp"
#include    "CIDTracer_BandedTextures.Hpp"

#include    "CIDTracer_Box.Hpp"
#include    "CIDTracer_CSG.Hpp"
#include    "CIDTracer_Light.Hpp"
#include    "CIDTracer_Plane.Hpp"
#include    "CIDTracer_Quadric.Hpp"
#include    "CIDTracer_Sphere.Hpp"

#include    "CIDTracer_ViewGeometry.Hpp"


// ----------------------------------------------------------------------------
//  Export the facility object. This stuff is defined in the main module.
// ----------------------------------------------------------------------------
extern CIDTRACEREXP TFacCIDTracer  facCIDTracer;

#endif
