//
// NAME: CIDLib_VolumeInfo.Hpp
//
// DESCRIPTION:
//
//  TVolumeInfo is a wrapper for the TKrnlFileSys::TVolumeInfo structure.
//  It is used to query the characteristics of a volume. CIDLib does not
//  do drives, it does volumes. But, for a drive based system, a volume
//  is just a path to the root directory of the drive. But, this scheme is
//  extensible to the future of distributed and mountable file systems.
//
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 06/12/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TVolumeInfo
//  PREFIX: voli
// ----------------------------------------------------------------------------
class CIDLIBEXP  TVolumeInfo : public TObject, public MDuplicable
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TVolumeInfo();

        TVolumeInfo
        (
            const   TString&                strVolumePath
        );

        TVolumeInfo
        (
            const   TVolumeInfo&            voliToAssign
        );

        TVolumeInfo
        (
            const   TKrnlFileSys::TRawVolumeInfo& RawVol
        );

        ~TVolumeInfo();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        tCIDLib::TBoolean operator==
        (
            const   TVolumeInfo&            voliToCompare
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TVolumeInfo&            voliToCompare
        )   const;

        TVolumeInfo& operator=
        (
            const   TVolumeInfo&            voliToAssign
        );

        TVolumeInfo& operator=
        (
            const   TKrnlFileSys::TRawVolumeInfo& RawVol
        );


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TCard4 c4BytesPerSector() const;

        tCIDLib::TCard4 c4MaxPathLenComp() const;

        tCIDLib::TCard4 c4SectorsPerUnit() const;

        tCIDLib::TCard4 c4TotalUnits() const;

        tCIDLib::TCard4 c4UnitsAvailable() const;

        tCIDLib::TCard4 c4VolumeSerialNum() const;

        tCIDLib::EFileSysFlags eFlags() const;

        const TString& strFileSysType() const;

        const TString& strVolumeLabel() const;

        const TString& strVolumePath() const;


    private :
        // --------------------------------------------------------------------
        //  Private, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid __FromRaw
        (
            const   TKrnlFileSys::TRawVolumeInfo& RawVol
        );


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __c4BytesPerSector
        //      This is the number of bytes in each sector on this volume.
        //
        //  __c4MaxPathLen
        //      The maximum length of a path component.
        //
        //  __c4SectorsPerUnit
        //      The number of sectors in an allocatable unit on this
        //      volume.
        //
        //  __c4TotalUnits
        //      The total number of allocatable units on the volume.
        //
        //  __c4UnitsAvailable
        //      The number of allocatable units available at the time of
        //      this call.
        //
        //  __c4VolumeSerialNum
        //      The serial number for this volume.
        //
        //  __eFileSysFlags
        //      These flags indicate various attributes of the file system
        //      of the volume.
        //
        //  __strFileSysType
        //      The name of the type of file system, e.g. FAT or NTFS.
        //
        //  __strVolumeLabel
        //      The volume label for this volume.
        //
        //  __strVolumePath
        //      The path to the volume that this info represents.
        // --------------------------------------------------------------------
        tCIDLib::TCard4         __c4BytesPerSector;
        tCIDLib::TCard4         __c4MaxPathCompLen;
        tCIDLib::TCard4         __c4SectorsPerUnit;
        tCIDLib::TCard4         __c4TotalUnits;
        tCIDLib::TCard4         __c4UnitsAvailable;
        tCIDLib::TCard4         __c4VolumeSerialNum;
        tCIDLib::EFileSysFlags  __eFlags;
        TString                 __strFileSysType;
        TString                 __strVolumeLabel;
        TString                 __strVolumePath;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TVolumeInfo,TObject)
        DefPolyDup(TVolumeInfo)
};

#pragma pack(pop)



// ----------------------------------------------------------------------------
//  Public operators
// ----------------------------------------------------------------------------
inline tCIDLib::TBoolean
TVolumeInfo::operator!=(const TVolumeInfo& voliToCompare) const
{
    return !operator==(voliToCompare);
}


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TCard4 TVolumeInfo::c4BytesPerSector() const
{
    return __c4BytesPerSector;
}

inline tCIDLib::TCard4 TVolumeInfo::c4MaxPathLenComp() const
{
    return __c4MaxPathCompLen;
}

inline tCIDLib::TCard4 TVolumeInfo::c4SectorsPerUnit() const
{
    return __c4SectorsPerUnit;
}

inline tCIDLib::TCard4 TVolumeInfo::c4TotalUnits() const
{
    return __c4TotalUnits;
}

inline tCIDLib::TCard4 TVolumeInfo::c4UnitsAvailable() const
{
    return __c4UnitsAvailable;
}

inline tCIDLib::TCard4 TVolumeInfo::c4VolumeSerialNum() const
{
    return __c4VolumeSerialNum;
}

inline tCIDLib::EFileSysFlags TVolumeInfo::eFlags() const
{
    return __eFlags;
}

inline const TString& TVolumeInfo::strFileSysType() const
{
    return __strFileSysType;
}

inline const TString& TVolumeInfo::strVolumeLabel() const
{
    return __strVolumeLabel;
}

inline const TString& TVolumeInfo::strVolumePath() const
{
    return __strVolumePath;
}
