//
// NAME: CIDLib_VolumeInfo.Cpp
//
// DESCRIPTION:
//
//  This module implements the TVolumeInfo class.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/13/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//

// -----------------------------------------------------------------------------
//  Facility specific includes
// -----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"

// -----------------------------------------------------------------------------
//  Do our RTTI macros
// -----------------------------------------------------------------------------
RTTIData2(TVolumeInfo,TObject)



// -----------------------------------------------------------------------------
//   CLASS: TVolumeInfo
//  PREFIX: voli
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TVolumeInfo: Constructors and Destructors
// -----------------------------------------------------------------------------

TVolumeInfo::TVolumeInfo() :

    __c4BytesPerSector(0)
    , __c4MaxPathCompLen(0)
    , __c4SectorsPerUnit(0)
    , __c4TotalUnits(0)
    , __c4UnitsAvailable(0)
    , __c4VolumeSerialNum(0)
    , __eFlags(tCIDLib::EFlSysFlag_None)
{
}

TVolumeInfo::TVolumeInfo(const TString& strVolumePath) :

    __c4BytesPerSector(0)
    , __c4MaxPathCompLen(0)
    , __c4SectorsPerUnit(0)
    , __c4TotalUnits(0)
    , __c4UnitsAvailable(0)
    , __c4VolumeSerialNum(0)
    , __eFlags(tCIDLib::EFlSysFlag_None)
    , __strVolumePath(strVolumePath)
{
    //
    //  Query the volume info for this volume and, if found, copy them
    //  to our members.
    //
    TKrnlFileSys::TRawVolumeInfo    VolInfo;
    try
    {
        TKrnlFileSys::QueryVolumeInfo(strVolumePath.pszData(), VolInfo);
    }

    catch(const TKrnlError& kerrToCatch)
    {
        facCIDLib.LogKrnlErr
        (
            __FILE__
            , __LINE__
            , kCIDErrs::errcFile_VolumeQuery
            , kerrToCatch
            , tCIDLib::ESev_APIFailed
            , tCIDLib::EClass_Unknown
            , strVolumePath
        );
    }

    // Copy over the info we got
    __FromRaw(VolInfo);
}

TVolumeInfo::TVolumeInfo(const TVolumeInfo& voliToCopy) :

    __c4BytesPerSector(voliToCopy.__c4BytesPerSector)
    , __c4MaxPathCompLen(voliToCopy.__c4MaxPathCompLen)
    , __c4SectorsPerUnit(voliToCopy.__c4SectorsPerUnit)
    , __c4TotalUnits(voliToCopy.__c4TotalUnits)
    , __c4UnitsAvailable(voliToCopy.__c4UnitsAvailable)
    , __c4VolumeSerialNum(voliToCopy.__c4VolumeSerialNum)
    , __eFlags(voliToCopy.__eFlags)
{
    __strVolumeLabel = voliToCopy.__strVolumeLabel;
    __strFileSysType = voliToCopy.__strFileSysType;
}

TVolumeInfo::~TVolumeInfo()
{
}


// -----------------------------------------------------------------------------
//  TVolumeInfo: Public operators
// -----------------------------------------------------------------------------

tCIDLib::TBoolean
TVolumeInfo::operator==(const TVolumeInfo& voliToCompare) const
{
    if (__c4BytesPerSector != voliToCompare.__c4BytesPerSector)
        return kCIDLib::False;

    if (__c4MaxPathCompLen != voliToCompare.__c4MaxPathCompLen)
        return kCIDLib::False;

    if (__c4SectorsPerUnit != voliToCompare.__c4SectorsPerUnit)
        return kCIDLib::False;

    if (__c4TotalUnits     != voliToCompare.__c4TotalUnits)
        return kCIDLib::False;

    if (__c4UnitsAvailable != voliToCompare.__c4UnitsAvailable)
        return kCIDLib::False;

    if (__c4VolumeSerialNum!= voliToCompare.__c4VolumeSerialNum)
        return kCIDLib::False;

    if (__eFlags != voliToCompare.__eFlags)
        return kCIDLib::False;

    if (__strVolumeLabel!= voliToCompare.__strVolumeLabel)
        return kCIDLib::False;

    if (__strFileSysType!= voliToCompare.__strFileSysType)
        return kCIDLib::False;

    return kCIDLib::True;
}


TVolumeInfo&
TVolumeInfo::operator=(const TVolumeInfo& voliToAssign)
{
    if (this == &voliToAssign)
        return *this;

    __c4BytesPerSector  = voliToAssign.__c4BytesPerSector;
    __c4MaxPathCompLen  = voliToAssign.__c4MaxPathCompLen;
    __c4SectorsPerUnit  = voliToAssign.__c4SectorsPerUnit;
    __c4TotalUnits      = voliToAssign.__c4TotalUnits;
    __c4UnitsAvailable  = voliToAssign.__c4UnitsAvailable;
    __c4VolumeSerialNum = voliToAssign.__c4VolumeSerialNum;
    __eFlags            = voliToAssign.__eFlags;

    __strVolumeLabel = voliToAssign.__strVolumeLabel;
    __strFileSysType = voliToAssign.__strFileSysType;

    return *this;
}

TVolumeInfo&
TVolumeInfo::operator=(const TKrnlFileSys::TRawVolumeInfo& RawVol)
{
    __FromRaw(RawVol);
    return *this;
}


// -----------------------------------------------------------------------------
//  TVolumeInfo: Public operators
// -----------------------------------------------------------------------------

tCIDLib::TVoid
TVolumeInfo::__FromRaw(const TKrnlFileSys::TRawVolumeInfo& RawVol)
{
    __c4BytesPerSector    = RawVol.c4BytesPerSector;
    __c4MaxPathCompLen    = RawVol.c4MaxPathCompLen;
    __c4SectorsPerUnit    = RawVol.c4SectorsPerUnit;
    __c4TotalUnits        = RawVol.c4TotalUnits;
    __c4UnitsAvailable    = RawVol.c4UnitsAvailable;
    __c4VolumeSerialNum   = RawVol.c4VolumeSerialNum;
    __eFlags              = RawVol.eFlags;
    __strFileSysType      = RawVol.szFileSysType;
    __strVolumeLabel      = RawVol.szVolumeLabel;
}
