//
// NAME: CIDLib_ValueMap2.Hpp
//
// DESCRIPTION: 
//
//  This header provides a couple of small derivatives of the abstract base
//  class TValueMap. TLogMap does a logarithmic mapping, TModuloMap does a
//  modulus division mapping.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/08/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TLogMap
// PREFIX: vmap
// -----------------------------------------------------------------------------
class CIDLIBEXP TLogMap : public TValueMap
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and destructors
        // ---------------------------------------------------------------------
        TLogMap();

        TLogMap
        (
            const   tCIDLib::TCard4         c4MaxIndex1
            , const tCIDLib::TCard4         c4MaxIndex2
            , const tCIDLib::ELogMapModes   eMode = tCIDLib::ELogMapMode_Spread
        );

        TLogMap
        (
            const   TLogMap&                vmapToCopy
        );

        ~TLogMap();


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TLogMap& operator=
        (
            const   TLogMap&                vmapToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TLogMap&                vmapToCompare
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TLogMap&                vmapToCompare
        )   const;


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TCard4 c4MapIndex
        (
            const   tCIDLib::TCard4         c4Index1
        )   const;

        tCIDLib::TVoid SetNewRanges
        (
            const   tCIDLib::TCard4         c4MaxIndex1
            , const tCIDLib::TCard4         c4MaxIndex2
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


    private :
        // ---------------------------------------------------------------------
        //  Private, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid __AllocTable();

        tCIDLib::TCard4 __c4ElemAt
        (
            const   tCIDLib::TCard4         c4Index
        )   const;

        tCIDLib::TVoid __InitTable();

        tCIDLib::TVoid __PutAt
        (
            const   tCIDLib::TCard4         c4Index
            , const tCIDLib::TCard4         c4Val
        );


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __ac1LogTable
        //      A pointer to the dynamically allocated mapping table. Its
        //      size depends upon the 1st max index and the size it takes to
        //      store a value of the second index. The __c4ElemAt() method
        //      handles internally getting values out, given the __c4ElemSize
        //      value.
        //
        //  __eMode
        //      This is the log mapping mode. There are two possibilities.
        //      One spreads out the lower values more smoothly than the raw
        //      mapping algorithm creates.
        //
        //  __c4ElemSize
        //      This is the number of bytes per index element in the array.
        //      We use the smallest we can get away with.
        // ---------------------------------------------------------------------
        tCIDLib::TCard1*        __ac1LogTable;
        tCIDLib::TCard4         __c4ElemSize;
        tCIDLib::ELogMapModes   __eMode;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TLogMap,TValueMap)
        DefPolyDup(TLogMap)
};


// -----------------------------------------------------------------------------
//  CLASS: TModMap
// PREFIX: vmap
// -----------------------------------------------------------------------------
class CIDLIBEXP TModMap : public TValueMap
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and destructors
        // ---------------------------------------------------------------------
        TModMap();

        TModMap
        (
            const   tCIDLib::TCard4         c4MaxIndex1
            , const tCIDLib::TCard4         c4MaxIndex2
        );

        TModMap
        (
            const   TModMap&                vmapToCopy
        );

        ~TModMap();


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TModMap& operator=
        (
            const   TModMap&                vmapToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TModMap&                vmapToCompare
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TModMap&                vmapToCompare
        )   const;


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TCard4 c4MapIndex
        (
            const   tCIDLib::TCard4         c4ToMap
        )   const;


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TModMap,TValueMap)
        DefPolyDup(TModMap)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  TLogMap: Public operators
// -----------------------------------------------------------------------------

inline tCIDLib::TBoolean TLogMap::operator!=(const TLogMap& vmapToCompare) const
{
    return !operator==(vmapToCompare);
}



// -----------------------------------------------------------------------------
//  TModMap: Constructors and Destructors
// -----------------------------------------------------------------------------
inline TModMap::TModMap() : TValueMap()
{
}

inline TModMap::TModMap(const   tCIDLib::TCard4 c4MaxIndex1
                        , const tCIDLib::TCard4 c4MaxIndex2) :

    TValueMap(c4MaxIndex1, c4MaxIndex2)
{
}

inline TModMap::TModMap(const TModMap& vmapToCopy) :

    TValueMap(vmapToCopy)
{
}

inline TModMap::~TModMap()
{
}


// -----------------------------------------------------------------------------
//  TModMap: Public operators
// -----------------------------------------------------------------------------
inline TModMap& TModMap::operator=(const TModMap& vmapToAssign)
{
    TParent::operator=(vmapToAssign);
    return *this;
}

inline tCIDLib::TBoolean
TModMap::operator==(const TModMap& vmapToCompare) const
{
    return TParent::operator==(vmapToCompare);
}

inline tCIDLib::TBoolean
TModMap::operator!=(const TModMap& vmapToCompare) const
{
    return !TParent::operator==(vmapToCompare);
}


// -----------------------------------------------------------------------------
//  TModMap: Public non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TCard4 TModMap::c4MapIndex(const tCIDLib::TCard4 c4ToMap) const
{
    return c4ToMap % c4MaxIndex2();
}


// -----------------------------------------------------------------------------
//  TModMap: Protected, inherited methods
// -----------------------------------------------------------------------------
inline tCIDLib::TVoid TModMap::_StreamFrom(TBinaryStream& strmToReadFrom)
{
    TParent::_StreamFrom(strmToReadFrom);
}

inline tCIDLib::TVoid TModMap::_StreamTo(TBinaryStream& strmToWriteTo) const
{
    TParent::_StreamTo(strmToWriteTo);
}
