//
// NAME: CIDLib_ValueMap.Hpp
//
// DESCRIPTION: 
//
//  This header provides a simple class for mapping one range of index values
//  to another. You put in one index and it returns the mapped index. This is
//  an often done operation, and we make it flexible by doing it as an abstract
//  base class from which a number of canned mapping systems can be derived and
//  used polymorphically. This lets a framework plug in different mapping
//  schemes dynamically.
//
//  CIDLib_ValueMap2.Hpp provides a couple of canned mappers that are of
//  general purpose use.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/08/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TValueMap
// PREFIX: vmap
// -----------------------------------------------------------------------------
class CIDLIBEXP TValueMap :

    public TObject, public MStreamable, public MDuplicable
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and destructors
        // ---------------------------------------------------------------------
        TValueMap();

        TValueMap
        (
            const   tCIDLib::TCard4         c4MaxIndex1
            , const tCIDLib::TCard4         c4MaxIndex2
        );

        TValueMap
        (
            const   TValueMap&              vmapToCopy
        );

        ~TValueMap();


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TValueMap& operator=
        (
            const   TValueMap&              vmapToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TValueMap&              vmapToCompare
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TValueMap&              vmapToCompare
        )   const;


        // ---------------------------------------------------------------------
        //  Public, virtual methods
        // ---------------------------------------------------------------------
        virtual tCIDLib::TCard4 c4MapIndex
        (
            const   tCIDLib::TCard4         c4Index1
        )   const = 0;

        virtual tCIDLib::TVoid SetNewRanges
        (
            const   tCIDLib::TCard4         c4MaxIndex1
            , const tCIDLib::TCard4         c4MaxIndex2
        );


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TCard4 c4MaxIndex1() const;

        tCIDLib::TCard4 c4MaxIndex2() const;


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __c4MaxIndex1
        //  __c4MaxIndex2
        //      The define the two index ranges we map between.
        // ---------------------------------------------------------------------
        tCIDLib::TCard4         __c4MaxIndex1;
        tCIDLib::TCard4         __c4MaxIndex2;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TValueMap,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Public operators
// -----------------------------------------------------------------------------
inline tCIDLib::TBoolean
TValueMap::operator!=(const TValueMap& vmapToCompare) const
{
    return !operator==(vmapToCompare);
}


// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TCard4 TValueMap::c4MaxIndex1() const
{
    return __c4MaxIndex1;
}

inline tCIDLib::TCard4 TValueMap::c4MaxIndex2() const
{
    return __c4MaxIndex2;
}
