//
// NAME: CIDLib_ValueMap.Cpp
//
// DESCRIPTION:
//
//  This module implements the abstract TValueMap class. This class is the
//  base class of a family of value mapping objects that can be dealt with
//  polymorphically.
//
//
//  AUTHOR: Dean Roddey
//
//  CREATE DATE: 09/08/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// -----------------------------------------------------------------------------
//  Facility specific includes
// -----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// -----------------------------------------------------------------------------
//  Do our standard members macros
// -----------------------------------------------------------------------------
RTTIData(TValueMap,TObject)



// -----------------------------------------------------------------------------
//  CLASS: TValueMap
// PREFIX: vmap
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TValueMap: Constructors and Destructors
// -----------------------------------------------------------------------------

TValueMap::TValueMap() :

    __c4MaxIndex1(1)
    , __c4MaxIndex2(1)
{
}

TValueMap::TValueMap(   const   tCIDLib::TCard4 c4MaxIndex1
                        , const tCIDLib::TCard4 c4MaxIndex2) :
    __c4MaxIndex1(c4MaxIndex1)
    , __c4MaxIndex2(c4MaxIndex2)
{
}

TValueMap::TValueMap(const TValueMap& vmapToCopy) :

    __c4MaxIndex1(vmapToCopy.__c4MaxIndex1)
    , __c4MaxIndex2(vmapToCopy.__c4MaxIndex2)
{
}

TValueMap::~TValueMap()
{
}


// -----------------------------------------------------------------------------
//  TValueMap: Public operators
// -----------------------------------------------------------------------------

TValueMap& TValueMap::operator=(const TValueMap& vmapToAssign)
{
    // Store the new indexes
    __c4MaxIndex1 = vmapToAssign.__c4MaxIndex1;
    __c4MaxIndex2 = vmapToAssign.__c4MaxIndex2;
    return *this;
}

tCIDLib::TBoolean
TValueMap::operator==(const TValueMap& vmapToCompare) const
{
    if (this == &vmapToCompare)
        return kCIDLib::True;

    if ((__c4MaxIndex1 != vmapToCompare.__c4MaxIndex1)
    ||  (__c4MaxIndex2 != vmapToCompare.__c4MaxIndex2))
    {
        return kCIDLib::False;
    }
    return kCIDLib::True;
}

// -----------------------------------------------------------------------------
//  TValueMap: Public, virtual methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid
TValueMap::SetNewRanges(const   tCIDLib::TCard4 c4MaxIndex1
                        , const tCIDLib::TCard4 c4MaxIndex2)
{
    // Store the new ones
    __c4MaxIndex1 = c4MaxIndex1;
    __c4MaxIndex2 = c4MaxIndex2;
}


// -----------------------------------------------------------------------------
//  TValueMap: Protected, inherited methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid TValueMap::_StreamFrom(TBinaryStream& strmToReadFrom)
{
    // Copy over the matrix values
    strmToReadFrom >> __c4MaxIndex1;
    strmToReadFrom >> __c4MaxIndex2;
}

tCIDLib::TVoid TValueMap::_StreamTo(TBinaryStream& strmToWriteTo) const
{
    strmToWriteTo << __c4MaxIndex1;
    strmToWriteTo << __c4MaxIndex2;
}
