//
// NAME: CIDLib_Type.Hpp
//
// DESCRIPTION: 
//
//  This header contains some stuff related to the types in the tCIDLib
//  namespace. For architectural reasons, CIDLib's namespace is actually
//  down in the kernel facility. For all other facility's, this file
//  would contain the namespace for types as well.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 04/02/95
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//
//


// -----------------------------------------------------------------------------
//  This macro generates the standard enum streaming methods. For the
//  one that formats to a text stream, the implementation must be provided,
//  since this only provides the definition. For enums that are just to be
//  binary streamed, another version is provided. It does all the work
//  required.
// -----------------------------------------------------------------------------
#define EnumStreamMacros(eEnumType) \
DLLEXPORT TTextStream& operator<<(TTextStream& strmToWriteTo, const eEnumType eVal); \
inline TBinaryStream& operator<<(TBinaryStream& strmToWriteTo, const eEnumType eVal) \
{ \
    strmToWriteTo.WriteEnum(eVal); \
    return strmToWriteTo; \
} \
 \
inline TBinaryStream& operator>>(TBinaryStream& strmToReadFrom, eEnumType& eVal) \
{ \
    eVal = (eEnumType)strmToReadFrom.eReadEnum(); \
    return strmToReadFrom; \
}

#define EnumBinStreamMacros(eEnumType) \
inline TBinaryStream& operator<<(TBinaryStream& strmToWriteTo, const eEnumType eVal) \
{ \
    strmToWriteTo.WriteEnum(eVal); \
    return strmToWriteTo; \
} \
 \
inline TBinaryStream& operator>>(TBinaryStream& strmToReadFrom, eEnumType& eVal) \
{ \
    eVal = (eEnumType)strmToReadFrom.eReadEnum(); \
    return strmToReadFrom; \
}


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CIDLib types that are not needed at the CIDKernel level, which provides
//  most of these types for us.
// -----------------------------------------------------------------------------
namespace tCIDLib
{
    // -------------------------------------------------------------------------
    //  A structure used to map enums to message text
    // -------------------------------------------------------------------------
    template <class E> struct TEnumTextMap
    {
        E                       eValue;
        tCIDLib::TMsgId         midText;
        const tCIDLib::Tch*     pszText;
    };
};

#pragma pack(pop)
