//
// NAME: CIDLib_ThisFacility.Hpp
//
// DESCRIPTION:
//
//  This is the header file for the CIDLib_ThisFacility.Cpp module. This
//  module implements the facility class for this facility. An object of this
//  class is created, named facCIDLib, and exported to the outside world to
//  give them access to this facility's global functionality and resources.
//
//  This class derives from the TFacility class, from which it inherits a lot
//  of functionality that is module handle oriented.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/26/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TFacCIDLib
// PREFIX: fac
// ----------------------------------------------------------------------------
class  CIDLIBEXP TFacCIDLib : public TFacility
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TFacCIDLib();

        ~TFacCIDLib();


        // --------------------------------------------------------------------
        //  Public, static methods
        // --------------------------------------------------------------------
        static const TAudio& audioDefault();

        static tCIDLib::TVoid AudioCue
        (
            const   tCIDLib::EAudioCues     eCue
        );

        static tCIDLib::TVoid Beep
        (
            const   tCIDLib::TCard4         c4Frequency
            , const tCIDLib::TCard4         c4Duration
        );

        static tCIDLib::TCard4 c4ObjectCount();

        static tCIDLib::TVoid DecObjectCount();

        static tCIDLib::TVoid ExitProcess
        (
            const   tCIDLib::EExitCodes     eExit
        );

        static tCIDLib::TVoid IncObjectCount();

        static TAudio* paudioAdoptDefAudioObj
        (
                    TAudio* const           paudioToAdopt
        );

        static tCIDLib::TVoid PopUpMsg
        (
            const   tCIDLib::Tsch* const    pszModule
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::Tch* const     pszTitle1
            , const tCIDLib::Tch* const     pszTitle2
            , const tCIDLib::Tch* const     pszMsg
            , const tCIDLib::Tch* const     pszMsg2 = 0
        );

        static tCIDLib::TVoid PopUpErr
        (
            const   tCIDLib::Tsch* const    pszModule
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::Tch* const     pszTitle1
            , const tCIDLib::Tch* const     pszTitle2
            , const tCIDLib::TErrCode       errcId
            , const tCIDLib::TErrCode       errcKrnlId
            , const tCIDLib::TOSErrCode     errcHostId
            , const tCIDLib::Tch* const     pszMsg
            , const tCIDLib::Tch* const     pszMsg2
        );


    protected   :
        // --------------------------------------------------------------------
        //  Declare our friends
        // --------------------------------------------------------------------
        friend tCIDLib::TVoid _InitTermThisFac
        (
            const   tCIDLib::EInitTerm      eInitTerm
            , const tCIDLib::EGlobalStates  eGlobals
            , const TModule&                modInit
            , const tCIDLib::TCard4         c4MaxChars
            ,       tCIDLib::Tch* const     pszFailReason
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplmented constructors and operators
        // --------------------------------------------------------------------
        TFacCIDLib(const TFacCIDLib&);

        tCIDLib::TVoid operator=(const TFacCIDLib&);


        // --------------------------------------------------------------------
        //  Private static, data members
        //
        //  __bInstallMode
        //      This is set if the user puts the /INSTALL option on the
        //      command line.
        //
        //  __paudioDef
        //      This is an TAudio object that is accessed via the
        //      audioDef() method. All clients use this to do sound output,
        //      and derived classes can derive from TAudio and install
        //      alternate sound output mechanisms by overriding this one.
        //
        //  __scntObjectCount
        //      If we are collecting object metrics, then this is used to
        //      hold the count.
        // --------------------------------------------------------------------
        static TAudio*              __paudioDef;
        static TKrnlSafeCounter     __scntObjectCount;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TFacCIDLib,TFacility)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, static methods
// ----------------------------------------------------------------------------
inline const TAudio& TFacCIDLib::audioDefault()
{
    return *__paudioDef;
}

inline tCIDLib::TVoid TFacCIDLib::AudioCue(const tCIDLib::EAudioCues eCue)
{
    __paudioDef->AudioCue(eCue);
}

inline tCIDLib::TCard4 TFacCIDLib::c4ObjectCount()
{
    return __scntObjectCount.i4Value();
}

inline tCIDLib::TVoid TFacCIDLib::DecObjectCount()
{
    __scntObjectCount.bDec();
}

inline tCIDLib::TVoid TFacCIDLib::IncObjectCount()
{
    __scntObjectCount.bInc();
}
