//
// NAME: CIDLib_TextMBufStream.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDLib_TextMBufStream.Cpp module. This
//  module provides a very simple derivative of TTextStream. It just
//  handles the management of the stream implementation object, which in
//  this case manages a memory buffer object. This stuff can all be done
//  manually, but this class just makes it safer.
//
//  Since these tend to be large, so it uses a system memory buffer which
//  can be committed over time without having to allocate another buffer
//  and copying the old contents in when the buffer needs to be expanded.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/01/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TTextMBufStream
//  PREFIX: strm
// ----------------------------------------------------------------------------
class CIDLIBEXP TTextMBufStream : public TTextStream
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TTextMBufStream
        (
            const   tCIDLib::TCard4         c4InitSize
            , const tCIDLib::ETextFormats   eTextFmt = tCIDLib::ETextFmt_UNICode
            , const tCIDLib::TCard4         c4MaxSize = kCIDLib::c4MaxCard
            , const tCIDLib::EMemAccFlags   eAccFlags = tCIDLib::EMemAcc_ReadWrite
        );

        ~TTextMBufStream();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TTextMBufStream();

        TTextMBufStream(const TTextMBufStream&);

        tCIDLib::TVoid operator=(const TTextMBufStream&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTextMBufStream, TTextStream)
};

#pragma pack(pop)
