//
// NAME: CIDLib_TextFileStream.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDLib_TextFileStream.Cpp module. This
//  module provides the TTextFileStream class, a very simple derivative of
//  TTextStream. It is a text stream with a file based implementation object.
//  It manages the implementation object for you, though you can also manually
//  create a text stream and a text file implementation object and get the
//  same result. This class just makes it easier and safer.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/28/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TTextFileStream
//  PREFIX: strm
// ----------------------------------------------------------------------------
class CIDLIBEXP TTextFileStream : public TTextStream
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TTextFileStream();

        TTextFileStream
        (
            const   TString&                strFileName
            , const tCIDLib::ETextFormats   eFormat
            , const tCIDLib::EAccessModes   eAccess
            , const tCIDLib::ECreateActions eAction
            , const tCIDLib::EFileAttrs     eAttrs
            , const tCIDLib::EFileFlags     eFlags
        );

        ~TTextFileStream();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid Close();

        tCIDLib::TVoid Open
        (
            const   TString&                strFileName
            , const tCIDLib::ETextFormats   eFormat
            , const tCIDLib::EAccessModes   eAccess
            , const tCIDLib::ECreateActions eAction
            , const tCIDLib::EFileAttrs     eAttrs
            , const tCIDLib::EFileFlags     eFlags
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TTextFileStream(const TTextFileStream&);

        tCIDLib::TVoid operator=(const TTextFileStream&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTextFileStream,TTextStream)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TVoid TTextFileStream::Close()
{
    //
    //  We know that the implementation object is a text file stream impl
    //  because we created it and there is no interface to replace it.
    //
    ((TFileTextStreamImpl&)_strmiThis()).Close();
}
