//
// NAME: CIDLib_TextFileStream.Cpp
//
// DESCRIPTION: 
//
//  This module implements a simple derivative of the text stream class.
//  This one handles the issues of creating the stream implementation
//  object and getting the file created and opened. You can do this yourself
//  and use a TBinaryStream, but this one is safer.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/26/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// ----------------------------------------------------------------------------
//  Do our standard members macros
// ----------------------------------------------------------------------------
RTTIData(TTextFileStream,TTextStream)


// ----------------------------------------------------------------------------
//  TTextFileStream: Constructors and destructors
// ----------------------------------------------------------------------------

TTextFileStream::TTextFileStream()
{
}

TTextFileStream::TTextFileStream(   const   TString&                strFileName
                                    , const tCIDLib::ETextFormats   eFormat
                                    , const tCIDLib::EAccessModes   eAccess
                                    , const tCIDLib::ECreateActions eAction
                                    , const tCIDLib::EFileAttrs     eAttrs
                                    , const tCIDLib::EFileFlags     eFlags)
{
    Open(strFileName, eFormat, eAccess, eAction, eAttrs, eFlags);
}

TTextFileStream::~TTextFileStream()
{
}


// ----------------------------------------------------------------------------
//  TTextFileStream: Public, non-virtual methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid
TTextFileStream::Open(  const   TString&                strFileName
                        , const tCIDLib::ETextFormats   eFormat
                        , const tCIDLib::EAccessModes   eAccess
                        , const tCIDLib::ECreateActions eAction
                        , const tCIDLib::EFileAttrs     eAttrs
                        , const tCIDLib::EFileFlags     eFlags)
{
    // Make sure that the implementation is not already set
    if (_bImplSet())
    {
        facCIDLib.LogErr
        (
            __FILE__
            , __LINE__
            , kCIDErrs::errcStrm_ImplAlreadySet
            , tCIDLib::ESev_APIFailed
            , tCIDLib::EClass_AppError
            , clsIsA()
        );
    }

    // Init these guys so we can clean up in case of error
    TBinaryFile*            pflToUse    = 0;
    TFileTextStreamImpl*    pstrmiToUse = 0;

    try
    {
        // Construct the binary file object
        pflToUse = new TBinaryFile(strFileName);

        // Try to open/create it with the provided information
        pflToUse->Open(eAccess, eAction, eAttrs, eFlags);

        //
        //  Ok, create the file stream implementation object and give it
        //  the file we just created and tell it to adopt it.
        //
        pstrmiToUse = new TFileTextStreamImpl
        (
            pflToUse
            , eFormat
            , tCIDLib::EAdoptOpt_Adopt
        );
    }

    catch(...)
    {
        if (pstrmiToUse)
        {
            delete pstrmiToUse;
            pstrmiToUse = 0;
        }
         else
        {
            delete pflToUse;
            pflToUse = 0;
        }
        throw;
    }

    // Pass on the new stream implementation object to our base class
    _AdoptImplObject(pstrmiToUse);
}
