//
// NAME: CIDLib_TextFileLogger.Hpp
//
// DESCRIPTION:
//
//  This is the header file for the CIDLib_TextFileLogger.Cpp module. This
//  module provides a simple derivative of TLogger, and supports logging
//  to a text output file. It optionally supports a named semaphore to
//  control logging by multiple processes. It does not have to worry about
//  multiple threads within the same process because calls to LogMsg()
//  are already synchronized by the calling thread in TFacility.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/27/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TTextFileLogger
// PREFIX: lgr
// ----------------------------------------------------------------------------
class CIDLIBEXP TTextFileLogger : public TLogger
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TTextFileLogger();

        TTextFileLogger
        (
            const   tCIDLib::Tch* const     pszFile
            , const tCIDLib::ETextFormats   eTextFmt = tCIDLib::ETextFmt_UNICode
            , const TResourceName&          rsnMutex = NUL_TResourceName
        );

        ~TTextFileLogger();


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid LogMsg
        (
            const   TError&                 errToLog
        );


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid Create
        (
            const   tCIDLib::Tch* const     pszFile
            , const tCIDLib::ETextFormats   eTextFmt = tCIDLib::ETextFmt_UNICode
            , const TResourceName&          rsnMutex = NUL_TResourceName
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TTextFileLogger(const TTextFileLogger&);

        tCIDLib::TVoid operator=(const TTextFileLogger&);


        // --------------------------------------------------------------------
        //  Private, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid __Create
        (
            const   tCIDLib::Tch* const     pszFile
            , const tCIDLib::ETextFormats   eTextFmt
            , const TResourceName&          rsnMutex
        );


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __pstrmTarget
        //      This is a text stream object for the target file. Errors
        //      are formatted to this stream.
        //
        //  __pmtxSync
        //      This is the optional named mutex that is used to sync
        //      multiple processes logging to the same file. If one was not
        //      provided, then no cross process synchronization is used.
        // --------------------------------------------------------------------
        TTextStream*    __pstrmTarget;
        TMutex*         __pmtxSync;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTextFileLogger,TLogger)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TVoid
TTextFileLogger::Create(const   tCIDLib::Tch* const     pszFile
                        , const tCIDLib::ETextFormats   eTextFmt
                        , const TResourceName&          rsnMutex)
{
    __Create(pszFile, eTextFmt, rsnMutex);
}
