//
// NAME: CIDLib_SystemInfo.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDLib_SystemInfo.Cpp module which implements
//  the TSysInfo class. A lot of what it does it just pass through to the
//  underlying TKrnlSysInfo class, which provides all of the platform
//  dependent stuff. It does though convert any raw strings to string objects
//  and such, but a lot of them are just straight inline pass throughs.
//
//  Like its parent, this guy is mostly static since it represents process
//  wide info that does not change. So mostly this stuff is accessed via the
//  class name and objects are not even created.
//
//  The inline passthroughs know for a fact that the underlying TKrnlSysInfo
//  methods that they call do not throw kernel errors. These underlying
//  methods are just returning member values. Any that can throw errors are
//  handled out of line and the usual translation to TError exceptions is
//  done.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/25/92
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TSysInfo
// PREFIX: sysi
// ----------------------------------------------------------------------------
class CIDLIBEXP TSysInfo : public TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TSysInfo();

        ~TSysInfo();


        // --------------------------------------------------------------------
        //  Public, static methods
        // --------------------------------------------------------------------
        static tCIDLib::TBoolean bFindInEnvironment
        (
            const   TString&                strEnvVarName
            ,       TString&                strToFill
        );

        static tCIDLib::TBoolean bInstallMode();

        static tCIDLib::TBoolean bObjectMetrics();

        static tCIDLib::TBoolean bObjectMetrics
        (
            const   tCIDLib::TBoolean       bNewState
        );

        static tCIDLib::TBoolean bTestMode();

        static tCIDLib::TBoolean bTestMode
        (
            const   tCIDLib::TBoolean       bNewState
        );

        static tCIDLib::TBoolean bVerboseMode();

        static tCIDLib::TBoolean bVerboseMode
        (
            const   tCIDLib::TBoolean       bNewState
        );

        static tCIDLib::TCard4 c4CmdLineArgCount();

        static tCIDLib::TCard4 c4CPUCount();

        static tCIDLib::TCard4 c4TotalPhysicalMem();

        static tCIDLib::TVoid CmdLineArg
        (
            const   tCIDLib::TCard4         c4ArgNum
            ,       TString&                strToFill
        );

        static tCIDLib::ECPUTypes eCPUType();

        static tCIDLib::EEndianModes eEndianMode();

        static tCIDLib::TProcessHandle hprocThis();

        static tCIDLib::TThreadHandle hthrCurrent();

        static tCIDLib::TProcessId pidThis();

        static tCIDLib::TVoid QueryOSInfo
        (
                    tCIDLib::TCard4&        c4OSMajVersion
            ,       tCIDLib::TCard4&        c4OSMinVersion
            ,       tCIDLib::TCard4&        c4OSBuildNum
        );

        static TString strUserName();

        static TRGBClr rgbSystemColor
        (
            const   tCIDLib::ESysColors     eSysColor
        );

        static TString strCommandLine();

        static TString strNodeName();

        static TString strProcessName();

        static tCIDLib::TThreadId tidCurrent();



    protected   :
        // --------------------------------------------------------------------
        //  Declare our friends
        // --------------------------------------------------------------------
        friend tCIDLib::TVoid _InitTermSysInfo
        (
            const  tCIDLib::EInitTerm      eInitTerm
            , const tCIDLib::EGlobalStates  eGlobals
            , const TModule&                modInit
            , const tCIDLib::TCard4         c4MaxChars
            ,       tCIDLib::Tch* const     pszFailReason
        );


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TSysInfo(const TSysInfo&);

        tCIDLib::TVoid operator=(const TSysInfo&);


        // ---------------------------------------------------------------------
        //  Private static, data members
        //
        //  __bInstallMode
        //      If the command line has the /INSTALL parm, it is removed
        //      and this flag is set to True.
        //
        //  __bObjectMetrics
        //      If the command line has the /OBJMETRICS parm, it is removed
        //      and this flag is set to True.
        //
        //  __bVerboseMode
        //      If the command line has the /VERBOSE parm, it is removed
        //      and this flag is set to True.
        // ---------------------------------------------------------------------
        static tCIDLib::TBoolean    __bInstallMode;
        static tCIDLib::TBoolean    __bObjectMetrics;
        static tCIDLib::TBoolean    __bTestMode;
        static tCIDLib::TBoolean    __bVerboseMode;

        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TSysInfo,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Constructors and destructors
// -----------------------------------------------------------------------------
inline TSysInfo::TSysInfo()
{
}

inline TSysInfo::~TSysInfo()
{
}


// -----------------------------------------------------------------------------
//  Public, static methods
// -----------------------------------------------------------------------------
inline tCIDLib::TBoolean TSysInfo::bInstallMode()
{
    return __bInstallMode;
}

inline tCIDLib::TBoolean TSysInfo::bObjectMetrics()
{
    return __bObjectMetrics;
}

inline tCIDLib::TBoolean
TSysInfo::bObjectMetrics(const tCIDLib::TBoolean bNewState)
{
    __bObjectMetrics = bNewState;
    return __bObjectMetrics;
}

inline tCIDLib::TBoolean TSysInfo::bVerboseMode()
{
    return __bVerboseMode;
}

inline tCIDLib::TBoolean
TSysInfo::bVerboseMode(const tCIDLib::TBoolean bNewState)
{
    __bVerboseMode = bNewState;
    return __bVerboseMode;
}

inline tCIDLib::TBoolean TSysInfo::bTestMode()
{
    return __bTestMode;
}

inline tCIDLib::TBoolean
TSysInfo::bTestMode(const tCIDLib::TBoolean bNewState)
{
    __bTestMode = bNewState;
    return __bTestMode;
}

inline tCIDLib::TCard4 TSysInfo::c4CmdLineArgCount()
{
    return TKrnlSysInfo::c4CmdLineArgCount();
}

inline tCIDLib::TCard4 TSysInfo::c4CPUCount()
{
    return TKrnlSysInfo::c4CPUCount();
}

inline tCIDLib::TCard4 TSysInfo::c4TotalPhysicalMem()
{
    return TKrnlSysInfo::c4TotalPhysicalMem();
}

inline tCIDLib::ECPUTypes TSysInfo::eCPUType()
{
    return TKrnlSysInfo::eCPUType();
}

inline tCIDLib::EEndianModes TSysInfo::eEndianMode()
{
    return TKrnlSysInfo::eEndianMode();
}

inline tCIDLib::TProcessHandle TSysInfo::hprocThis()
{
    return TKrnlSysInfo::hprocThis();
}

inline tCIDLib::TThreadHandle TSysInfo::hthrCurrent()
{
    return TKrnlSysInfo::hthrCurrent();
}

inline tCIDLib::TProcessId TSysInfo::pidThis()
{
    return TKrnlSysInfo::pidThis();
}

inline tCIDLib::TVoid
TSysInfo::QueryOSInfo(  tCIDLib::TCard4&    c4OSMajVersion
                        , tCIDLib::TCard4&  c4OSMinVersion
                        , tCIDLib::TCard4&  c4OSBuildNum)
{
    TKrnlSysInfo::QueryOSInfo(c4OSMajVersion, c4OSMinVersion, c4OSBuildNum);
}

inline TString TSysInfo::strCommandLine()
{
    return TString(TKrnlSysInfo::pszCommandLine());
}

inline TString TSysInfo::strNodeName()
{
    return TString(TKrnlSysInfo::pszNodeName());
}

inline TString TSysInfo::strProcessName()
{
    return TString(TKrnlSysInfo::pszProcessName());
}

inline tCIDLib::TThreadId TSysInfo::tidCurrent()
{
    return TKrnlSysInfo::tidCurrent();
}
