//
// NAME: CIDLib_StringStream.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDLib_StringStream.Cpp module, which
//  implements the TStringStream class. This is a convenience class that
//  makes it quick to format into a string object. It basically just
//  knows how to make use of the string as the data sink/source and to
//  put the stream into text mode.
//
//  It also provides a constructor that will build the string for you. It
//  will also take a string size and construct a string and adopt it.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/28/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// -----------------------------------------------------------------------------
//  Forward references
// -----------------------------------------------------------------------------
class TStreamFmt;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TStringStream
//  PREFIX: strm
// -----------------------------------------------------------------------------
class CIDLIBEXP TStringStream : public TTextStream
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and destructors
        // ---------------------------------------------------------------------
        TStringStream
        (
                    TString* const          pstrData
            , const TStreamFmt&             strmfToUse
            , const tCIDLib::EAdoptOpts     eAdopt = tCIDLib::EAdoptOpt_NoAdopt
        );

        TStringStream
        (
                    TString* const          pstrData
            , const tCIDLib::EAdoptOpts     eAdopt = tCIDLib::EAdoptOpt_NoAdopt
        );

        TStringStream
        (
            const   tCIDLib::TCard4         c4InitChars
            , const tCIDLib::TCard4         c4MaxChars = 0
            , const TStreamFmt&             strmfToUse = NUL_TStreamFmt
        );

        ~TStringStream();


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        operator const TString&() const;


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        TString& strData();

        const TString& strData() const;


    private     :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TStringStream();

        TStringStream(const TStringStream&);

        tCIDLib::TVoid operator=(const TStringStream&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TStringStream,TTextStream)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Public operators
// -----------------------------------------------------------------------------
inline TStringStream::operator const TString&() const
{
    return strData();
}
