//
// NAME: CIDLib_StringStream.Cpp
//
// DESCRIPTION:
//
//  This module implements the TStringStream class, which provides a text
//  mode stream with a string object as the data sink/source. This is a
//  very common configuration so its worth having this convenience class
//  to make it easy.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 04/03/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// -----------------------------------------------------------------------------
//  Includes
// -----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// -----------------------------------------------------------------------------
//  Do our standard members macros
// -----------------------------------------------------------------------------
RTTIData(TStringStream,TTextStream)



// -----------------------------------------------------------------------------
//   CLASS: TStringStream
//  PREFIX: strm
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TStringStream: Constructors and operators
// -----------------------------------------------------------------------------

TStringStream::TStringStream(           TString* const      pstrToUse
                                , const TStreamFmt&         strmfToUse
                                , const tCIDLib::EAdoptOpts eAdopt)
{
    // Create the stream implementation object and set it in our parent
    TStringStreamImpl* pstrmiTmp = new TStringStreamImpl(pstrToUse, eAdopt);
    _AdoptImplObject(pstrmiTmp);

    // And set the stream format if it was provided
    if (&strmfToUse)
        SetFormat(strmfToUse);
}

TStringStream::TStringStream(           TString* const      pstrToUse
                                , const tCIDLib::EAdoptOpts eAdopt)
{
    // Create the stream implementation object and set it in our parent
    TStringStreamImpl* pstrmiTmp = new TStringStreamImpl(pstrToUse, eAdopt);
    _AdoptImplObject(pstrmiTmp);
}

TStringStream::TStringStream(   const   tCIDLib::TCard4     c4InitChars
                                , const tCIDLib::TCard4     c4MaxChars
                                , const TStreamFmt&         strmfToUse)
{
    // Create the implementation object
    TStringStreamImpl*  pstrmiToUse = new TStringStreamImpl
    (
        c4InitChars
        , c4MaxChars
    );

    // Now install the implementation on our parent
    _AdoptImplObject(pstrmiToUse);

    // If there was a stream format, then set it
    if (&strmfToUse)
        SetFormat(strmfToUse);
}

TStringStream::~TStringStream()
{
}


// -----------------------------------------------------------------------------
//  TStringStream: Public, non-virtual methods
// -----------------------------------------------------------------------------

TString& TStringStream::strData()
{
    return ((TStringStreamImpl&)_strmiThis()).strData();
}

const TString& TStringStream::strData() const
{
    return ((const TStringStreamImpl&)_strmiThis()).strData();
}
