//
// NAME: CIDLib_StreamParser.Hpp
//
// DESCRIPTION:
//
//  This file provides the TStreamParser class. This class provides token
//  parsing services for text streams. Basically it provides a lot of the grunt
//  work that is always associated with parsing text files. A simple derivative
//  of this class can create a powerful parser.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/28/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TStreamParser
//  PREFIX: prsr
// ----------------------------------------------------------------------------
class CIDLIBEXP TStreamParser : public TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TStreamParser
        (
                    TTextStream* const      pstrmToUse
            , const tCIDLib::EAdoptOpts     eAdopt
        );

        ~TStreamParser();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid AddSyntaxToken
        (
            const   TString&                strBuf
        );

        tCIDLib::TCard4 c4CurLine() const;

        tCIDLib::Tch chGetNextChar();

        tCIDLib::TVoid FlushLine();

        tCIDLib::TVoid GetNextToken
        (
            const   TString&                strSeparators
            ,       TString&                strTarget
            , const TString&                strNoSyntax = NUL_TString
        );

        tCIDLib::TVoid GetLineRemainder
        (
                    TString&                strTarget
        );

        tCIDLib::TVoid UnGetChar
        (
            const   tCIDLib::Tch            chPush
        );

        tCIDLib::TVoid UnGetToken
        (
            const   TString&                strToUnGet
        );

        tCIDLib::TVoid UnGetToken
        (
            const   tCIDLib::Tch* const     pszToUnGet
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors/operators
        // --------------------------------------------------------------------
        TStreamParser();

        TStreamParser(const TStreamParser&);

        TStreamParser& operator=(const TStreamParser&);


        // --------------------------------------------------------------------
        //  A private enum for the __eTokenMatch() method.
        // --------------------------------------------------------------------
        enum    eTokenMatches
        {
            eMatch_None
            , eMatch_First
            , eMatch_Full
        };


        // --------------------------------------------------------------------
        //  Private, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::Tch __chGetNext();

        eTokenMatches __eTokenMatch
        (
            const   tCIDLib::Tch            chFirst
            , const tCIDLib::Tch            chSecond    = 0
            , const TString&                strNoSyntax = NUL_TString
        );

        tCIDLib::TVoid __UnGet
        (
            const   tCIDLib::Tch            chPush
        );


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __c4CurLine
        //      This is updated to reflect the current line of the input
        //      file. It is bumped up each time that a newline character is
        //      passed.
        //
        //  __c4TokenIndex
        //      This is the current count of items in the __ac2Tokens[]
        //      array. AddSyntaxToken() bumps up this index as new tokens
        //      are added.
        //
        //  __eAdopt
        //      This indicates whether we adopted the stream that we are
        //      parsing. If so, we delete it when we destruct.
        //
        //  __i4StackIndex
        //      This is the index of the current pushback stack stop. It is
        //      just an index into __pchCharStack. If the stack is empty it
        //      set to -1.
        //
        //  __pac4Tokens
        //      This is a list of the tokens. Since they are all 1 or 2 chars,
        //      we encoded them in a TCard4 value. This makes for fast
        //      comparisons, i.e. fast compiles. __c4TokenIndex is the current
        //      index into this array. AddSyntaxToken() is used to load
        //      the list.
        //
        //  __pchCharStack
        //      This is a stack for pushing characters back. It is allocated
        //      as required, though its limited in size to a few K.
        //
        //  __pstrmSrc
        //      This is the stream input source. It can be adopted or just
        //      referenced.
        // --------------------------------------------------------------------
        tCIDLib::TCard4         __c4CurLine;
        tCIDLib::TCard4         __c4TokenIndex;
        tCIDLib::EAdoptOpts     __eAdopt;
        tCIDLib::TInt4          __i4StackIndex;
        tCIDLib::TCard4*        __pac4Tokens;
        tCIDLib::Tch*           __pchCharStack;
        TTextStream*            __pstrmSrc;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TStreamParser,TObject)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TCard4 TStreamParser::c4CurLine() const
{
    return __c4CurLine;
}

inline tCIDLib::Tch TStreamParser::chGetNextChar()
{
    return __chGetNext();
}

inline tCIDLib::TVoid TStreamParser::UnGetChar(const tCIDLib::Tch chPush)
{
    __UnGet(chPush);
}
