//
// NAME: CIDLib_StreamFmt.Hpp
//
//  This header defines the TStreamFmt class. The actual implementation is
//  in TTextStream.Cpp along with the TTextStream class that this class
//  works with. This class makes it easy to deal with all of the formatting
//  settings of a text stream as a unit.
//
//
// DESCRIPTION:
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 04/03/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TStreamFmt
//  PREFIX: strmf
// -----------------------------------------------------------------------------
class CIDLIBEXP TStreamFmt :

    public TObject, public MDuplicable, public MStreamable
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        TStreamFmt();

        TStreamFmt
        (
            const   tCIDLib::TCard4         c4Width
            , const tCIDLib::TCard4         c4Precision
            , const tCIDLib::EHJustify      eJustification
            , const tCIDLib::Tch            chFill
        );

        TStreamFmt
        (
            const   TStreamFmt&             strmfToCopy
        );

        TStreamFmt
        (
            const   TTextStream&            strmSource
        );

        ~TStreamFmt() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TStreamFmt& operator=
        (
            const   TStreamFmt&             strmfToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TStreamFmt&             strmfToCompare
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TStreamFmt&             strmfToCompare
        )   const;


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::Tch chFill() const;

        tCIDLib::Tch chFill
        (
            const   tCIDLib::Tch            chFill
        );

        tCIDLib::TCard4 c4Precision() const;

        tCIDLib::TCard4 c4Precision
        (
            const   tCIDLib::TCard4         c4Precision
        );

        tCIDLib::TCard4 c4Width() const;

        tCIDLib::TCard4 c4Width
        (
            const   tCIDLib::TCard4         c4Width
        );

        tCIDLib::EHJustify eJustification() const;

        tCIDLib::EHJustify eJustification
        (
            const   tCIDLib::EHJustify      eJustify
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Declare our friends
        // ---------------------------------------------------------------------
        friend class TTextStream;


        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToWriteTo
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


    protected   :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __chFill
        //      The file character to use when text formatting into a field
        //      larger than the text being formatted.
        //
        //  __c4Precision
        //      The number of decimal digits to use when formatting a floating
        //      point value.
        //
        //  __c4Width
        //      The field width to format into.
        //
        //  __eJustification
        //      This is the horizontal justification to use if an inserted
        //      string is smaller than the current field width.
        // ---------------------------------------------------------------------
        tCIDLib::Tch            __chFill;
        tCIDLib::TCard4         __c4Precision;
        tCIDLib::TCard4         __c4Width;
        tCIDLib::EHJustify      __eJustification;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TStreamFmt,TObject)
        DefPolyDup(TStreamFmt)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Constructors and destructors
// -----------------------------------------------------------------------------
inline TStreamFmt::TStreamFmt() :

    __c4Precision(2)
    , __c4Width(0)
    , __chFill(kCIDLib::chSpace)
    , __eJustification(tCIDLib::EHJustify_Left)
{
}

inline
TStreamFmt::TStreamFmt( const   tCIDLib::TCard4     c4Width
                        , const tCIDLib::TCard4     c4Precision
                        , const tCIDLib::EHJustify  eJustification
                        , const tCIDLib::Tch        chFill) :
    __c4Precision(c4Precision)
    , __c4Width(c4Width)
    , __chFill(chFill)
    , __eJustification(eJustification)
{
}

inline TStreamFmt::TStreamFmt(const TStreamFmt& strmfToCopy) :

    __c4Precision(strmfToCopy.__c4Precision)
    , __c4Width(strmfToCopy.__c4Width)
    , __chFill(strmfToCopy.__chFill)
    , __eJustification(strmfToCopy.__eJustification)
{
}

// -----------------------------------------------------------------------------
//  Public operators
// -----------------------------------------------------------------------------
inline tCIDLib::TBoolean
TStreamFmt::operator!=(const TStreamFmt& strmfToCompare) const
{
    return !operator==(strmfToCompare);
}


// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::Tch TStreamFmt::chFill() const
{
    return __chFill;
}

inline tCIDLib::Tch TStreamFmt::chFill(const tCIDLib::Tch chFill)
{
    __chFill = chFill;
    return __chFill;
}

inline tCIDLib::TCard4 TStreamFmt::c4Precision() const
{
    return __c4Precision;
}

inline tCIDLib::TCard4
TStreamFmt::c4Precision(const tCIDLib::TCard4 c4Precision)
{
    __c4Precision = c4Precision;
    return __c4Precision;
}

inline tCIDLib::TCard4 TStreamFmt::c4Width() const
{
    return __c4Width;
}

inline tCIDLib::TCard4 TStreamFmt::c4Width(const tCIDLib::TCard4 c4Width)
{
    __c4Width = c4Width;
    return __c4Width;
}

inline tCIDLib::EHJustify TStreamFmt::eJustification() const
{
    return __eJustification;
}

inline tCIDLib::EHJustify
TStreamFmt::eJustification(const tCIDLib::EHJustify eJustification)
{
    __eJustification = eJustification;
    return __eJustification;
}
