//
// NAME: CIDLib_StreamFmt.Cpp
//
// DESCRIPTION:
//
//  This module implements the TStreamFmt class, which is a helper class for
//  the TTextStream class. It provides a way to manipulate all of the
//  formatting attributes of a text stream as a whole.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 04/03/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//



// -----------------------------------------------------------------------------
//  Includes
// -----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// -----------------------------------------------------------------------------
//  Do our standard members macros
// -----------------------------------------------------------------------------
RTTIData2(TStreamFmt,TObject)



// -----------------------------------------------------------------------------
//   CLASS: TStreamFmt
//  PREFIX: strmf
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TStreamFmt: Constructors and destructors
// -----------------------------------------------------------------------------

TStreamFmt::TStreamFmt(const TTextStream& strmSource) :

    __c4Precision(strmSource.__c4Precision)
    , __c4Width(strmSource.__c4Width)
    , __chFill(strmSource.__chFill)
    , __eJustification(strmSource.__eJustification)
{
}


// -----------------------------------------------------------------------------
//  TStreamFmt: Public operators
// -----------------------------------------------------------------------------

TStreamFmt& TStreamFmt::operator=(const TStreamFmt& strmfToAssign)
{
    if (this == &strmfToAssign)
        return *this;

    __c4Precision       = strmfToAssign.__c4Precision;
    __c4Width           = strmfToAssign.__c4Width;
    __chFill            = strmfToAssign.__chFill;
    __eJustification    = strmfToAssign.__eJustification;
    return *this;
}

tCIDLib::TBoolean TStreamFmt::operator==(const TStreamFmt& strmfToCompare) const
{
    if (this == &strmfToCompare)
        return kCIDLib::True;

    if ((__c4Precision != strmfToCompare.__c4Precision)
    ||  (__c4Width != strmfToCompare.__c4Width)
    ||  (__chFill != strmfToCompare.__c4Precision)
    ||  (__eJustification != strmfToCompare.__eJustification))
    {
        return kCIDLib::False;
    }
    return kCIDLib::True;
}


// ----------------------------------------------------------------------------
//  TArea: Protected, inherited methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid TStreamFmt::_StreamFrom(TBinaryStream& strmToReadFrom)
{
    strmToReadFrom  >> __c4Precision
                    >> __c4Width
                    >> __eJustification
                    >> __chFill;
}

tCIDLib::TVoid TStreamFmt::_StreamTo(TBinaryStream& strmToWriteTo) const
{
    strmToWriteTo   << __c4Precision
                    << __c4Width
                    << __eJustification
                    << __chFill;
}
