//
// NAME: CIDLib_Stream.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the TStream.Cpp module. This module provides the
//  implementations and definitions for the most fundamental streaming classes.
//  TSteam is the base class of all streams and provides the basic interface
//  that all streams must provide. These methods are non-virtual because they
//  are implemented in terms of the implementation object.
//
//  Also defined here is the abstract class TStreamImpl, which is the basis of
//  all stream implementation classes. Stream implmenetation classes provide
//  the data sink/source services for a stream. At this level, it is the same
//  for text and binary streams, but there are derivatives that provide the
//  abstract base classes for text and binary stream implementation classes.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 07/16/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// -----------------------------------------------------------------------------
//  Forward references
// -----------------------------------------------------------------------------
class   TMemBuf;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TStream
//  PREFIX: strm
// -----------------------------------------------------------------------------
class CIDLIBEXP TStream : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        ~TStream();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean bEndOfStream() const;

        tCIDLib::TFilePos fposCurPos() const;

        tCIDLib::TFilePos fposQueryLogicalEnd() const;

        tCIDLib::TFilePos fposQueryPhysicalEnd() const;

        tCIDLib::TFilePos fposSeekToEnd();

        tCIDLib::TFilePos fposSkipForwardBy
        (
            const   tCIDLib::TCard4         c4SkipBy
        );

        tCIDLib::TVoid Reset();


    protected   :
        // ---------------------------------------------------------------------
        //  Hidden constructors
        // ---------------------------------------------------------------------
        TStream
        (
                    TStreamImpl* const      pstrmiToAdopt
        );

        TStream();


        // ---------------------------------------------------------------------
        //  Protected, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _AdoptImplObject
        (
                    TStreamImpl* const      pstrmiToAdopt
        );

        TStreamImpl& _strmiThis();

        const TStreamImpl& _strmiThis() const;



    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and destructors
        // ---------------------------------------------------------------------
        TStream(const TStream&);

        tCIDLib::TVoid operator=(const TStream&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __pstrmiThis
        //      This is a pointer to our stream implementation object. We
        //      adopt it and kill it when we die. We basically pass most of
        //      methods on to it or write them in terms of it.
        // ---------------------------------------------------------------------
        TStreamImpl*        __pstrmiThis;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TStream,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Protected, non-virtual methods
// -----------------------------------------------------------------------------
inline TStream::TStream() :

    __pstrmiThis(0)
{
}

// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TBoolean TStream::bEndOfStream() const
{
    return __pstrmiThis->bEndOfStream();
}

inline tCIDLib::TFilePos TStream::fposCurPos() const
{
    return __pstrmiThis->fposCurPos();
}

inline tCIDLib::TFilePos TStream::fposQueryLogicalEnd() const
{
    return __pstrmiThis->fposQueryLogicalEnd();
}

inline tCIDLib::TFilePos TStream::fposQueryPhysicalEnd() const
{
    return __pstrmiThis->fposQueryPhysicalEnd();
}

inline tCIDLib::TFilePos TStream::fposSeekToEnd()
{
    return __pstrmiThis->fposSeekToEnd();
}

inline tCIDLib::TFilePos
TStream::fposSkipForwardBy(const tCIDLib::TCard4 c4SkipBy)
{
    __pstrmiThis->fposSkipForwardBy(c4SkipBy);
    return __pstrmiThis->fposCurPos();
}

inline tCIDLib::TVoid TStream::Reset()
{
    __pstrmiThis->Reset();
}
