//
// NAME: CIDLib_Stream.Cpp
//
// DESCRIPTION: 
//
//  This module implements the TStream class, which is a pure virtual
//  class for moving data to/from data sources/sinks.
//
//  Streams are only for sequential access. They can be reset or seeked
//  forward but then read/written sequentially from that point. The current
//  position is adjusted for each read/write operation.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 07/16/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// ----------------------------------------------------------------------------
//  Do our RTTI macros
// ----------------------------------------------------------------------------
RTTIData(TStreamImpl,TObject)
RTTIData(TStream,TObject)



// ----------------------------------------------------------------------------
//   CLASS: TStream
//  PREFIX: strm
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TStream: Public Constructors and destructors
// ----------------------------------------------------------------------------

TStream::~TStream()
{
    delete __pstrmiThis;
    __pstrmiThis = 0;
}


// ----------------------------------------------------------------------------
//  TStream: Protected Constructors and destructors
// ----------------------------------------------------------------------------

TStream::TStream(TStreamImpl* const pstrmiToAdopt) :

    __pstrmiThis(pstrmiToAdopt)
{
}


// ----------------------------------------------------------------------------
//  TStream: Protected, non-virtual methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid TStream::_AdoptImplObject(TStreamImpl* const pstrmiToUse)
{
    if (__pstrmiThis)
    {
        facCIDLib.LogErr
        (
            __FILE__
            , __LINE__
            , kCIDErrs::errcStrm_ImplAlreadySet
            , tCIDLib::ESev_APIFailed
            , tCIDLib::EClass_AppError
            , clsIsA()
        );
    }
    __pstrmiThis = pstrmiToUse;
}


TStreamImpl& TStream::_strmiThis()
{
    if (!__pstrmiThis)
    {
        facCIDLib.LogErr
        (
            __FILE__
            , __LINE__
            , kCIDErrs::errcStrm_NoImplementation
            , tCIDLib::ESev_APIFailed
            , tCIDLib::EClass_AppError
            , clsIsA()
        );
    }
    return *__pstrmiThis;
}

const TStreamImpl& TStream::_strmiThis() const
{
    if (!__pstrmiThis)
    {
        facCIDLib.LogErr
        (
            __FILE__
            , __LINE__
            , kCIDErrs::errcStrm_NoImplementation
            , tCIDLib::ESev_APIFailed
            , tCIDLib::EClass_AppError
            , clsIsA()
        );
    }
    return *__pstrmiThis;
}
