//
// NAME: CIDLib_StdOutLogger.Hpp
//
// DESCRIPTION:
//
//  This is the header file for the CIDLib_StdOutLogger.Cpp module. This
//  module provides a simple derivative of TLogger, and supports logging
//  to the standard out file. It optionally supports a named mutex to
//  control logging by multiple processes. It does not have to worry about
//  multiple threads within the same process because calls to LogMsg()
//  are already synchronized by the calling thread in TModule.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/27/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TStdOutLogger
// PREFIX: lgr
// ----------------------------------------------------------------------------
class CIDLIBEXP TStdOutLogger : public TLogger
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TStdOutLogger();

        TStdOutLogger
        (
            const   TResourceName&          rsnMutex
        );

        ~TStdOutLogger();


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid LogMsg
        (
            const   TError&                 errToLog
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TStdOutLogger(const TStdOutLogger&);

        tCIDLib::TVoid operator=(const TStdOutLogger&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __pmtxSync
        //      This is the optional named mutex that is used to sync
        //      multiple processes logging to the same file. If one was not
        //      provided, then no cross process synchronization is used.
        // --------------------------------------------------------------------
        TMutex*     __pmtxSync;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TStdOutLogger,TLogger)
};

#pragma pack(pop)
