//
// NAME: CIDLib_StatusController.Hpp
//
// DESCRIPTION: 
//
//  This class implements a pure virtual class called TStatusContoller. This
//  class abstracts the standard communications that occur between a program
//  and a background thread that is doing work for it. The background thread
//  needs to indicate ongoing status of the operation and completion. The
//  program just creates a simple derivaitve of this class to handle the
//  correct actions for those generic interations.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/21/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TStatusController
//  PREFIX: statc
// -----------------------------------------------------------------------------
class CIDLIBEXP TStatusController : public TObject, public MDuplicable
{
    public  :
        // ---------------------------------------------------------------------
        //  Constuctors and Destructors
        // ---------------------------------------------------------------------
        TStatusController();

        TStatusController
        (
            const   TStatusController&      statcToCopy
        );

        ~TStatusController();


        // ---------------------------------------------------------------------
        //  Public, pure virtual methods
        // ---------------------------------------------------------------------
        virtual tCIDLib::TVoid Starting
        (
            const   TString&                strStartText
        ) = 0;

        virtual tCIDLib::TVoid WaitForComplete
        (
            const   tCIDLib::TCard4         c4MilliSecs
        ) = 0;

        virtual tCIDLib::TVoid Working
        (
            const   TString&                strStatusText
            , const tCIDLib::TCard4         c4PercentComplete
         ) = 0;

        virtual tCIDLib::TVoid WorkComplete
        (
            const   TString&                strClosingComment
        ) = 0;


    private :
        // --------------------------------------------------------------------
        //  Unimplimented operaors
        // --------------------------------------------------------------------
        tCIDLib::TVoid operator=(const TStatusController&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TStatusController,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Constructors and Destructors
// -----------------------------------------------------------------------------
inline TStatusController::TStatusController()
{
}

inline TStatusController::TStatusController(const TStatusController&)
{
}

inline TStatusController::~TStatusController()
{
}
