//
// NAME: CIDLib_Size.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDLib_Size.Cpp module, which implements the
//  TSize class. This class represents a positive extent in a 2D integral
//  coordinate space.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/10/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//

#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TSize
//  PREFIX: sz
// -----------------------------------------------------------------------------
class CIDLIBEXP TSize :

    public TObject, public MStreamable, public MDuplicable, public MFormattable
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        TSize();

        TSize
        (
            const   tCIDLib::THostSize&     szToCopy
        );

        TSize
        (
            const   tCIDLib::TCard4         c4CX
            , const tCIDLib::TCard4         c4CY
        );

        TSize
        (
            const   tCIDLib::TCard4         c4Both
        );

        TSize
        (
            const   TSize&                  szToCopy
        );

        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        operator const tCIDLib::THostSize&() const;

        tCIDLib::TVoid operator=
        (
            const   TSize&                  szToAssign
        );

        tCIDLib::TVoid operator+=
        (
            const   TSize&                  szToAdd
        );

        friend TSize CIDLIBEXP operator+
        (
            const   TSize&                  sz1
            , const TSize&                  sz2
        );

        tCIDLib::TVoid operator-=
        (
            const   TSize&                  szToSub
        );

        friend TSize CIDLIBEXP operator-
        (
            const   TSize&                  sz1
            , const TSize&                  sz2
        );

        tCIDLib::TBoolean operator==
        (
            const   TSize&                  szToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TSize&                  szToTest
        )   const;


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid Adjust
        (
            const   tCIDLib::TInt4          i4XOfs
            , const tCIDLib::TInt4          i4YOfs
        );

        tCIDLib::TVoid Adjust
        (
            const   tCIDLib::TInt4          i4Ofs
        );

        tCIDLib::TVoid AdjustCX
        (
            const   tCIDLib::TInt4          i4Ofs
        );

        tCIDLib::TVoid AdjustCY
        (
            const   tCIDLib::TInt4          i4Ofs
        );

        tCIDLib::TBoolean bAllZero() const;

        tCIDLib::TCard4 c4SquareUnits() const;

        tCIDLib::TCard4 c4Packed() const;

        tCIDLib::TCard4 c4Height() const;

        tCIDLib::TCard4 c4Height
        (
            const   tCIDLib::TCard4         c4New
        );

        tCIDLib::TCard4 c4Width() const;

        tCIDLib::TCard4 c4Width
        (
            const   tCIDLib::TCard4         c4New
        );

        tCIDLib::TCard4 c4X() const;

        tCIDLib::TCard4 c4X
        (
                    tCIDLib::TCard4         c4XNew
        );

        tCIDLib::TCard4 c4Y() const;

        tCIDLib::TCard4 c4Y
        (
                    tCIDLib::TCard4         c4YNew
        );

        tCIDLib::TVoid Exchange();

        tCIDLib::TVoid Set
        (
            const   tCIDLib::TCard4         c4CXNew
            , const tCIDLib::TCard4         c4CYNew
        );

        tCIDLib::TVoid ToHostPt
        (
                    tCIDLib::THostPoint&    ptToFill
        )   const;

        tCIDLib::TVoid ToHostSize
        (
                    tCIDLib::THostSize&     szToFill
        )   const;

        tCIDLib::TVoid Zero();


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __c4CX
        //  __c4CY
        //      These are the extents in the x and y axes.
        // ---------------------------------------------------------------------
        tCIDLib::TCard4         __c4CX;
        tCIDLib::TCard4         __c4CY;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TSize,TObject)
        DefPolyDup(TSize)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Public operators
// -----------------------------------------------------------------------------
inline TSize::operator const tCIDLib::THostSize&() const
{
    return *((const tCIDLib::THostSize*)&__c4CX);
}

inline tCIDLib::TBoolean TSize::operator!=(const TSize& szToTest) const
{
    return !operator==(szToTest);
}


// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TBoolean TSize::bAllZero() const
{
    return (!__c4CX && !__c4CY);
}

inline tCIDLib::TCard4 TSize::c4Height() const
{
    return __c4CY;
}

inline tCIDLib::TCard4 TSize::c4Height(const tCIDLib::TCard4 c4New)
{
    __c4CY = c4New;
    return __c4CY;
}

inline tCIDLib::TCard4 TSize::c4SquareUnits() const
{
    return __c4CX * __c4CY;
}

inline tCIDLib::TCard4 TSize::c4Width() const
{
    return __c4CX;
}

inline tCIDLib::TCard4 TSize::c4Width(const tCIDLib::TCard4 c4New)
{
    __c4CX = c4New;
    return __c4CX;
}

inline tCIDLib::TCard4 TSize::c4X() const
{
    return __c4CX;
}

inline tCIDLib::TCard4 TSize::c4X(tCIDLib::TCard4 c4XNew)
{
    __c4CX = c4XNew;
    return __c4CX;
}

inline tCIDLib::TCard4 TSize::c4Y() const
{
    return __c4CY;
}

inline tCIDLib::TCard4 TSize::c4Y(tCIDLib::TCard4 c4YNew)
{
    __c4CY = c4YNew;
    return __c4CY;
}

inline tCIDLib::TVoid TSize::Exchange()
{
    tCIDLib::TCard4 i4Tmp = __c4CX;
    __c4CX=__c4CY;
    __c4CY=i4Tmp;
}

inline tCIDLib::TVoid
TSize::Set(const tCIDLib::TCard4 c4CXNew, const tCIDLib::TCard4 c4CYNew)
{
    __c4CX = c4CXNew;
    __c4CY = c4CYNew;
}

inline tCIDLib::TVoid TSize::Zero()
{
    __c4CX = 0;
    __c4CY = 0;
}


// -----------------------------------------------------------------------------
//  Typedef TSize to another name, TQ1Point. Since a cartesian point in the
//  1st quadrant has basically the same functionality, we use this class for
//  both. It has methods to look at the values either way, i.e. as a size or
//  as a point value.
// -----------------------------------------------------------------------------
typedef TSize       TQ1Point;
