//
//  FILE NAME: CIDLib_SafeCounter.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/11/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This header implements a simple, atomic counter (i.e. its thread safe)
//  value that can be incremented, decremented, queried, or added to.
//
//  CAVEATS/GOTCHAS:
//
//  1)  The underlying kernel wrapper class provides all of the public
//      interface we need and does not expose any APIs that this class would
//      need to hide. So this class just derives from the kernel class
//      directly and lets it provide the public API without any passthrough
//      wrappers.
//
//  2)  Since this class is all inline, its RTTI macros are in CIDLib.Cpp.
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TSafeCounter
//  PREFIX: scnt
// ----------------------------------------------------------------------------
class CIDLIBEXP TSafeCounter : public TObject, public TKrnlSafeCounter
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TSafeCounter();

        TSafeCounter
        (
            const   tCIDLib::TInt4          i4InitVal
        );

        ~TSafeCounter();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TSafeCounter(const TSafeCounter&);

        tCIDLib::TVoid operator=(const TSafeCounter&);


        // --------------------------------------------------------------------
        //  Do any needed macros
        // --------------------------------------------------------------------
        RTTIMacros(TSafeCounter,TObject)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Constructors and Destructors
// ----------------------------------------------------------------------------
inline TSafeCounter::TSafeCounter()
{
}

inline TSafeCounter::TSafeCounter(const tCIDLib::TInt4 i4InitVal) :

    TKrnlSafeCounter(i4InitVal)
{
}

inline TSafeCounter::~TSafeCounter()
{
}
