//
// NAME: CIDLib_RTTI.Hpp
//
// DESCRIPTION:
//
//  This file implements some standard templates and macros that are
//  used by the custom RTTI support.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 12/15/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


// ----------------------------------------------------------------------------
//  These are the standard macros that go into classes to endow them with
//  RTTI info.
// ----------------------------------------------------------------------------
#define RTTIMacros(Class,ParentClass) \
private : \
typedef ParentClass TParent; \
public  :   \
static const TClass clsThis; \
tCIDLib::TBoolean bIsDescendantOf(const TClass& clsTarget) const \
{ \
    if (clsTarget == Class::clsThis) \
        return kCIDLib::True; \
     else \
        return ParentClass::bIsDescendantOf(clsTarget); \
} \
\
const TClass& clsIsA() const \
{ \
    return Class::clsThis; \
} \
\
const TClass& clsParent() const \
{ \
    return ParentClass::clsThis; \
}


// ----------------------------------------------------------------------------
//  For RTTI also, but goes into the Cpp file of each class that uses the
//  RTTIMacros() macro above.
//
//  There is a second version that is used if this class is to support
//  dynamic typing. It will call a different TClass constructor, which
//  takes a factory function (created here automatically.)
// ----------------------------------------------------------------------------
#define RTTIData(Class,ParentClass) \
const TClass Class::clsThis(L#Class);

#define RTTIData2(Class,ParentClass) \
TObject* pMakeNew_##Class() {return new Class;} \
const TClass Class::clsThis(L#Class, pMakeNew_##Class);


// ----------------------------------------------------------------------------
//  If you want to hide your default constructor use this macro. Dynamic
//  typing requires that the default constructor be available to the factory
//  function, so this macro will make it a friend of your class. That way
//  you can hide it but still be polymorphically streamable and dynamically
//  creatable.
// ----------------------------------------------------------------------------
#define BefriendFactory(Class) \
friend TObject* pMakeNew_##Class();
