//
// NAME: CIDLib_PopUpLogger.Cpp
//
// DESCRIPTION:
//
//  This module implements a popup logger, which sends logged errors to a
//  the standard popup mechanism.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/27/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// -----------------------------------------------------------------------------
//  Includes
// -----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// -----------------------------------------------------------------------------
//  Do our RTTI macros
// -----------------------------------------------------------------------------
RTTIData2(TPopUpLogger,TLogger)



// -----------------------------------------------------------------------------
//  TPopUpLogger: Constructors and operators
// -----------------------------------------------------------------------------

TPopUpLogger::TPopUpLogger()
{
}

TPopUpLogger::~TPopUpLogger()
{
}


// -----------------------------------------------------------------------------
//  TPopUpLogger: Public, inherited methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid TPopUpLogger::LogMsg(const TError& errToLog)
{
    TKrnlPopup::Show
    (
        errToLog.strFileName().pszData()
        , errToLog.c4LineNum()
        , kCIDLib_::pszTitle1
        , kCIDLib_::pszTitle2
        , errToLog.errcId()
        , errToLog.errcKrnlId()
        , errToLog.errcHostId()
        , errToLog.strErrText().pszData()
        , errToLog.strAuxText().pszData()
    );
}
