//
// NAME: CIDLib_Pointer.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDLib_Pointer.Cpp module, which implements
//  the TPointer class. This is a very simple class and is just for the
//  formatting of pointers to streams. Normally, if you try to format a
//  pointer to a stream, it misinterprets this in one way or another
//  according to the available formatting overrides available. This class
//  just makes sure that it comes out with the correct format and in hex
//  format. We could use TCardinal for this, but we don't want to assume
//  always that a pointer and a TCardinal are the same size or have the
//  same formatting issues.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 07/02/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TPointer
// PREFIX: ptr
// ----------------------------------------------------------------------------
class CIDLIBEXP TPointer :

    public TObject, public MFormattable, public MDuplicable
{
    public  :
        // --------------------------------------------------------------------
        // Constructors and Destructors
        // --------------------------------------------------------------------
        TPointer();

        TPointer
        (
            const   TPointer&               ptrToCopy
        );

        TPointer
        (
            const   TVoid* const            pPointer
        );

        ~TPointer();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        TPointer& operator=
        (
            const   TPointer&               ptrToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TPointer&               ptrToCompare
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TPointer&               ptrToCompare
        )   const;



    protected :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmDest
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __pData
        //      This is the pointer that we are to format
        // --------------------------------------------------------------------
        const tCIDLib::TVoid*   __pData;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TPointer,TObject)
        DefPolyDup(TPointer)
};

#pragma pack(pop)



// ----------------------------------------------------------------------------
//  Constructors and destructors
// ----------------------------------------------------------------------------
inline TPointer::TPointer() :

    __pData(0)
{
}

inline TPointer::TPointer(const TPointer& ptrToCopy) :

    __pData(ptrToCopy.__pData)
{
}

inline TPointer::TPointer(const tCIDLib::TVoid* const pPointer) :

    __pData(pPointer)
{
}

inline TPointer::~TPointer()
{
}


// ----------------------------------------------------------------------------
//  Public operators
// ----------------------------------------------------------------------------

inline TPointer& TPointer::operator=(const TPointer& ptrToAssign)
{
    __pData = ptrToAssign.__pData;
    return *this;
}

inline tCIDLib::TBoolean
TPointer::operator==(const TPointer& ptrToCompare) const
{
    return (__pData == ptrToCompare.__pData);
}

inline tCIDLib::TBoolean
TPointer::operator!=(const TPointer& ptrToCompare) const
{
    return (__pData != ptrToCompare.__pData);
}
