//
// NAME: CIDLib_Point.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDLib_Point.Cpp module. This module implements
//  the TPoint class, which is a point in a 2 dimensional, integral coordinate
//  space.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/10/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//

// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class   TArea;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TPoint
//  PREFIX: pnt
// ----------------------------------------------------------------------------
class CIDLIBEXP TPoint :

    public TObject, public MStreamable, public MDuplicable, public MFormattable
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TPoint();

        TPoint
        (
            const   tCIDLib::THostPoint&    ptToCopy
        );

        TPoint
        (
            const   tCIDLib::TInt4          i4X
            , const tCIDLib::TInt4          i4Y
        );

        TPoint
        (
            const   tCIDLib::TInt4          i4Both
        );

        TPoint
        (
            const   TPoint&                 pntToFopy
        );

        ~TPoint();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        operator const tCIDLib::THostPoint*() const;

        operator tCIDLib::THostPoint*();

        tCIDLib::TVoid operator=
        (
            const   TPoint&                 pntToAssign
        );

        tCIDLib::TVoid operator+=
        (
            const   TPoint&                 pntToAdd
        );

        friend TPoint CIDLIBEXP operator+
        (
            const   TPoint&                 pnt1
            , const TPoint&                 pnt2
        );

        tCIDLib::TVoid operator-=
        (
            const   TPoint&                 pntToSub
        );

        friend TPoint CIDLIBEXP operator-
        (
            const   TPoint&                 pnt1
            , const TPoint&                 pnt2
        );

        tCIDLib::TBoolean operator==
        (
            const   TPoint&                 pntToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TPoint&                 pntToTest
        )   const;


        // --------------------------------------------------------------------
        //  Pubic, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid Adjust
        (
            const   tCIDLib::TInt4          i4XOfs
            , const tCIDLib::TInt4          i4YOfs
        );

        tCIDLib::TVoid AdjustX
        (
            const   tCIDLib::TInt4          i4Ofs
        );

        tCIDLib::TVoid AdjustY
        (
            const   tCIDLib::TInt4          i4Ofs
        );

        tCIDLib::TBoolean bAtOrg() const;

        tCIDLib::TBoolean bInArea
        (
            const   TArea&                  areaToTest
        )   const;

        tCIDLib::TCard4 c4Packed() const;

        tCIDLib::TVoid Exchange();

        tCIDLib::TVoid FromHostPt
        (
            const   tCIDLib::THostPoint&    ptToCopy
        );

        tCIDLib::TInt4 i4X() const;

        tCIDLib::TInt4 i4X
        (
                    tCIDLib::TInt4          i4XNew
        );

        tCIDLib::TInt4 i4Y() const;

        tCIDLib::TInt4 i4Y
        (
                    tCIDLib::TInt4          i4YNew
        );

        tCIDLib::TVoid Negate();

        tCIDLib::TVoid NegateX();

        tCIDLib::TVoid NegateY();

        tCIDLib::TVoid Scale
        (
            const   tCIDLib::TFloat4        f4CXScale
            , const tCIDLib::TFloat4        f4CYScale
        );

        tCIDLib::TVoid Set
        (
            const   tCIDLib::TInt4          i4XNew
            , const tCIDLib::TInt4          i4YNew
        );

        tCIDLib::TVoid ToHostPt
        (
                    tCIDLib::THostPoint&    ptToFill
        )   const;

        tCIDLib::TVoid Zero();


    protected   :
        // --------------------------------------------------------------------
        //  Declare our friends
        // --------------------------------------------------------------------
        friend class    TArea;

        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&             strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&             strmToWriteTo
        )   const;

    private     :
        // --------------------------------------------------------------------
        //  Private data members
        //
        //  Note that these are packed to 4 bytes so that they will be
        //  just like a raw host point structure.
        //
        //  __i4X
        //  __i4Y
        //      Storage for the x,y coordinates.
        // --------------------------------------------------------------------
        #pragma pack(push, 4)
        tCIDLib::TInt4          __i4X;
        tCIDLib::TInt4          __i4Y;
        #pragma pack(pop)


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TPoint,TObject)
        DefPolyDup(TPoint)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Constructors and destructors
// ----------------------------------------------------------------------------
inline TPoint::~TPoint()
{
}


// ----------------------------------------------------------------------------
//  Public operators
// ----------------------------------------------------------------------------
inline tCIDLib::TBoolean TPoint::operator!=(const TPoint& pntToTest) const
{
    return !operator==(pntToTest);
}


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TBoolean TPoint::bAtOrg() const
{
    return (!__i4X && !__i4Y);
}

inline tCIDLib::TVoid TPoint::Exchange()
{
    tCIDLib::TInt4 i4Tmp = __i4X;
    __i4X=__i4Y;
    __i4Y=i4Tmp;
}

inline tCIDLib::TInt4 TPoint::i4X() const
{
    return __i4X;
}

inline tCIDLib::TInt4 TPoint::i4X(tCIDLib::TInt4 i4XNew)
{
    __i4X = i4XNew;
    return __i4X;
}

inline tCIDLib::TInt4 TPoint::i4Y() const
{
    return __i4Y;
}

inline tCIDLib::TInt4 TPoint::i4Y(tCIDLib::TInt4 i4YNew)
{
    __i4Y = i4YNew;
    return __i4Y;
}

inline tCIDLib::TVoid
TPoint::Set(const tCIDLib::TInt4 i4XNew, const tCIDLib::TInt4 i4YNew)
{
    __i4X = i4XNew;
    __i4Y = i4YNew;
}

inline tCIDLib::TVoid TPoint::Negate()
{
    __i4X *= -1;
    __i4Y *= -1;
}

inline tCIDLib::TVoid TPoint::NegateX()
{
    __i4X *= -1;
}

inline tCIDLib::TVoid TPoint::NegateY()
{
    __i4Y *= -1;
}

inline tCIDLib::TVoid TPoint::Zero()
{
    __i4X = 0;
    __i4Y = 0;
}

