//
// NAME: CIDLib_PerThreadData_.Hpp
//
// DESCRIPTION:
//
//  This is a private header that is only used by TThread, so its included
//  directly into CIDLib_Thread.Cpp. It provides the tiny class that is used
//  as the elements in the list of per-thread data objects.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 04/16/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// GOTCHAS/CAVEATS:
//


// -----------------------------------------------------------------------------
//  Forward references
// -----------------------------------------------------------------------------
class   TPerThreadData;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TPerThreadData
//  PREFIX: ptd
// -----------------------------------------------------------------------------
class CIDLIBEXP TPerThreadData : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Contructors and Destructors
        // ---------------------------------------------------------------------
        TPerThreadData
        (
            const   TString&                strElemName
            , const TClass&                 clsOfData
        );

        ~TPerThreadData();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        const TClass& clsOfData() const;

        tCIDLib::THashVal hshName() const;

        const TString& strName() const;


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TPerThreadData();

        TPerThreadData(const TPerThreadData&);

        tCIDLib::TVoid operator=(const TPerThreadData&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __clsOfData
        //      This is the class of the data. It is used to dynamically
        //      allocate objects when they are required.
        //
        //  __hshName
        //      The name is hashed for very fast lookup.
        //
        //  __strName
        //      This is the name of the element. This is how users of the
        //      data extract it.
        // ---------------------------------------------------------------------
        TClass              __clsOfData;
        tCIDLib::THashVal   __hshName;
        TString             __strName;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TPerThreadData,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Constructors and Destructors
// -----------------------------------------------------------------------------
inline
TPerThreadData::TPerThreadData( const   TString&    strElemName
                                , const TClass&     clsOfData) :
    __clsOfData(clsOfData)
    , __hshName(0)
    , __strName(strElemName)
{
    // Calculate the hash for this one
    __hshName = __strName.hshCalcHash(kCIDLib::c4ClassModulus);
}

inline TPerThreadData::~TPerThreadData()
{
}


// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline const TClass& TPerThreadData::clsOfData() const
{
    return __clsOfData;
}

inline tCIDLib::THashVal TPerThreadData::hshName() const
{
    return __hshName;
}

inline const TString& TPerThreadData::strName() const
{
    return __strName;
}
