//
// NAME: CIDLib_PathString.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDLib_PathStr.Cpp module. This module implements
//  the TPathStr class, which is a derivative of TString that knows how to
//  interpret its cotnents as a file system path. It is fully interopable with
//  strings but is far more convenient when dealing with path names.
//
//  Definitely use a TPathStr when streaming out file names, because it will
//  provide format translation of path names between platforms in the future.
//
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 06/12/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TPathStr
// PREFIX: path
// -----------------------------------------------------------------------------
class CIDLIBEXP TPathStr : public TString
{
    public  :
        // ---------------------------------------------------------------------
        //  Nested public types
        // ---------------------------------------------------------------------
        struct  TPathComp
        {
            tCIDLib::Tch    chDrive;
            tCIDLib::TZStr8 szVolume;
            tCIDLib::TCard4 c4PathOfs, c4PathEnd;
            tCIDLib::TCard4 c4NameOfs, c4NameEnd;
            tCIDLib::TCard4 c4ExtOfs, c4ExtEnd;
            tCIDLib::TCard4 c4NodeOfs, c4NodeEnd;
        };


        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        // ---------------------------------------------------------------------
        TPathStr();

        TPathStr
        (
            const   tCIDLib::Tch* const     pszInitValue
        );

        TPathStr
        (
            const   TString&                strInitComp
        );

        TPathStr
        (
            const   TPathStr&               pathToCopy
        );

        ~TPathStr();


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TPathStr& operator=
        (
            const   TPathStr&               pathToAssign
        );

        TPathStr& operator=
        (
            const   TString&                strToAssign
        );

        TPathStr& operator=
        (
            const   tCIDLib::Tch* const     pszToAssign
        );


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid AddLevel
        (
            const   TString&                strNewLevel
        );

        tCIDLib::TVoid AppendExtension
        (
            const   TString&                strExt
        );

        tCIDLib::TBoolean bIsSpecialDir() const;

        tCIDLib::TBoolean bHasExt() const;

        tCIDLib::TBoolean bParseComponents
        (
                    TPathComp&              PathInfo
        )   const;

        tCIDLib::TBoolean bQueryExt
        (
                    TString&                strToFill
        )   const;

        tCIDLib::TBoolean bQueryName
        (
                    TString&                strToFill
        )   const;

        tCIDLib::TBoolean bQueryNameExt
        (
                    TString&                strToFill
        )   const;

        tCIDLib::TBoolean bQueryPath
        (
                    TString&                strToFill
        )   const;

        tCIDLib::TBoolean bQueryVolume
        (
                    TString&                strToFill
        )   const;

        tCIDLib::TBoolean bRemoveExt();

        tCIDLib::TBoolean bRemoveLevel();

        tCIDLib::TBoolean bRemoveName();

        tCIDLib::TBoolean bRemoveNameExt();

        tCIDLib::TBoolean bRemovePath();

        tCIDLib::TBoolean bRemoveTrailingSeparator();

        tCIDLib::Tch chDrive() const;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TPathStr,TString)
        DefPolyDup(TPathStr)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Public operators
// -----------------------------------------------------------------------------
inline TPathStr& TPathStr::operator=(const TPathStr& pathToAssign)
{
    TString::operator=(pathToAssign); return *this;
}

inline TPathStr& TPathStr::operator=(const TString& strToAssign)
{
    TString::operator=(strToAssign); return *this;
}

inline TPathStr& TPathStr::operator=(const tCIDLib::Tch* const pszToAssign)
{
    TString::operator=(pszToAssign); return *this;
}
