//
// NAME: CIDLib_Object.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDLib_Object.Cpp module. This module
//  implements the base CIDLib class, TObject, from which all others are
//  derived. This class defines the RTTI interface that all must 
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 01/06/92
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class CIDLIBEXP TClass;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TObject
// PREFIX: obj
// ----------------------------------------------------------------------------
class CIDLIBEXP TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        virtual ~TObject();


        // --------------------------------------------------------------------
        //  Public, static data members
        // --------------------------------------------------------------------
        static const TClass clsThis;


        // --------------------------------------------------------------------
        //  Public, virtual methods
        // --------------------------------------------------------------------
        virtual tCIDLib::TBoolean bIsDescendantOf
        (
            const   TClass&              clsTarget
        )   const = 0;

        virtual const TClass& clsIsA() const = 0;

        virtual const TClass& clsParent() const = 0;


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bIsA
        (
            const   TClass&              clsTest
        )   const;


    protected :
        // --------------------------------------------------------------------
        //  Hidden Constructors and operators
        // --------------------------------------------------------------------
        TObject();

        TObject(const TObject&);
};

#pragma pack(pop)
