//
// NAME: CIDLib_Object.Cpp
//
// DESCRIPTION:
//
//  This module implements the TObject class, which is the fundamental
//  clas of the system, from which everything else is derived.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/20/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"



// -----------------------------------------------------------------------------
//  CLASS: TObject
// PREFIX: obj
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TObject: Static data
// -----------------------------------------------------------------------------
const TClass TObject::clsThis(L"TObject");


// -----------------------------------------------------------------------------
//  TObject: Constructors and Destructors
// -----------------------------------------------------------------------------

TObject::TObject()
{
    if (TSysInfo::bObjectMetrics())
    {
        // Bump up the internal counter
        TFacCIDLib::IncObjectCount();

        // And update the metrics
        _pmtrgCore->OffsetCard(tCIDLib_::eCoreMetric_ObjCount, 1);
    }
}

TObject::TObject(const TObject&)
{
    if (TSysInfo::bObjectMetrics())
    {
        // Bump up the internal counter
        TFacCIDLib::IncObjectCount();

        // And update the metrics
        _pmtrgCore->OffsetCard(tCIDLib_::eCoreMetric_ObjCount, 1);
    }
}

TObject::~TObject()
{
    if (TSysInfo::bObjectMetrics())
    {
        // Bump up the internal counter
        TFacCIDLib::DecObjectCount();

        // And update the metrics
        if (_pmtrgCore)
            _pmtrgCore->OffsetCard(tCIDLib_::eCoreMetric_ObjCount, -1);
    }
}


// -----------------------------------------------------------------------------
//  TObject: Public, virtual methods
// -----------------------------------------------------------------------------

tCIDLib::TBoolean TObject::bIsDescendantOf(const TClass& clsTarget) const
{
    //
    //  This is the end of the line, so either its equal to our class or
    //  we are not a descendant of the passed clsas.
    //
    return (clsTarget == clsThis);
}

const TClass& TObject::clsIsA() const
{
    return clsThis;
}

const TClass& TObject::clsParent() const
{
    return NUL_TClass;
}


// -----------------------------------------------------------------------------
//  TObject: Public, non-virtual methods
// -----------------------------------------------------------------------------

tCIDLib::TBoolean TObject::bIsA(const TClass& clsTest) const
{
    return (clsTest == clsIsA());
}
