//
// NAME: CIDLib_MutexLock.Hpp
//
// DESCRIPTION: 
//
//  This module implements a small class that simplifies the locking and
//  unlocking of mutexes on a scope basis.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/27/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class   TMutex;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TMtxLock
//  PREFIX: mtxl
// ----------------------------------------------------------------------------
class TMtxLock
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TMtxLock
        (
                    TMutex* const           pmtxToLock
            , const tCIDLib::TCard4         c4TimeOut = kCIDLib::c4MaxWait
        );

        ~TMtxLock();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TMtxLock();

        TMtxLock(const TMtxLock&);

        tCIDLib::TVoid operator=(const TMtxLock&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __pkmtxToLock
        //      This is the mutex object that we are to lock and unlock.
        //      A pointer to it is stored.
        // --------------------------------------------------------------------
        TMutex*     __pmtxToLock;
};

#pragma pack(pop)
