//
// NAME: CIDLib_MutexLock.Cpp
//
// DESCRIPTION:
//
//  This module implements the TMutexLock class. Its a very simple janitor
//  for mutex locks.
//
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 06/20/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// ----------------------------------------------------------------------------
//   CLASS: TMtxLock
//  PREFIX: 
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TMtxLock: Constructors and operators
// ----------------------------------------------------------------------------

TMtxLock::TMtxLock(TMutex* const pmtxToLock, const tCIDLib::TCard4 c4TimeOut) :

    __pmtxToLock(0)
{
    // See if we can lock it
    pmtxToLock->Lock(c4TimeOut);

    // We could so now store it
    __pmtxToLock = pmtxToLock;
}

TMtxLock::~TMtxLock()
{
    // If we got it locked, then unlock it
    if (__pmtxToLock)
        __pmtxToLock->Unlock();
}
