//
// NAME: CIDLib_Money.Hpp
//
// DESCRIPTION:
//
//  This is the definition file for the CIDLib_Money.Cpp module. This module
//  implements the TMoney class, which supports formatting of values that
//  represent monetary values. Monetary values are assumed to be floating
//  point values and this class allows them to be dumped to text streams
//  and formatted according to locale rules.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/15/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//

#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TMoney
// PREFIX: mon
// ----------------------------------------------------------------------------
class CIDLIBEXP TMoney :

    public TObject, public MDuplicable, public MFormattable, public MStreamable
{
    public  :
        // --------------------------------------------------------------------
        // Constructors and Destructors
        // --------------------------------------------------------------------
        TMoney();

        TMoney
        (
            const   TMoney&                 monToCopy
        );

        TMoney
        (
            const   tCIDLib::TFloat8        f8Val
        );

        ~TMoney();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        operator tCIDLib::TFloat8() const;

        TMoney& operator=
        (
            const   TMoney&                 monToAssign
        );

        TMoney& operator=
        (
            const   tCIDLib::TFloat8        f8ToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TMoney&                 monToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TMoney&                 monToTest
        )   const;

        tCIDLib::TBoolean operator==
        (
            const   tCIDLib::TFloat8        f8ToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   tCIDLib::TFloat8        f8ToTest
        )   const;

        tCIDLib::TBoolean operator<
        (
            const   TMoney&                 monToTest
        )   const;

        tCIDLib::TBoolean operator<=
        (
            const   TMoney&                 monToTest
        )   const;

        tCIDLib::TBoolean operator>
        (
            const   TMoney&                 monToTest
        )   const;

        tCIDLib::TBoolean operator>=
        (
            const   TMoney&                 monToTest
        )   const;


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TFloat8 f8Val() const;

        tCIDLib::TFloat8 f8Val
        (
            const   tCIDLib::TFloat8        f8NewVal
        );

    protected   :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmDest
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&             strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&             strmToWriteTo
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __f8Val
        //      Storage for the data value
        // --------------------------------------------------------------------
        tCIDLib::TFloat8    __f8Val;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TMoney,TObject)
        DefPolyDup(TMoney)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Constructors and destrutors
// ----------------------------------------------------------------------------
inline TMoney::~TMoney()
{
}

// ----------------------------------------------------------------------------
//  Public operators
// ----------------------------------------------------------------------------
inline TMoney::operator tCIDLib::TFloat8() const
{
    return __f8Val;
}

inline TMoney& TMoney::operator=(const tCIDLib::TFloat8 f8NewVal)
{
    __f8Val = f8NewVal;
    return *this;
}

inline tCIDLib::TBoolean TMoney::operator!=(const TMoney& monToTest) const
{
    return !operator==(monToTest);
}

inline tCIDLib::TBoolean TMoney::operator==(const tCIDLib::TFloat8 f8ToTest) const
{
    return (f8ToTest == __f8Val);
}

inline tCIDLib::TBoolean TMoney::operator!=(const tCIDLib::TFloat8 f8ToTest) const
{
    return (f8ToTest != __f8Val);
}

inline tCIDLib::TBoolean TMoney::operator<(const TMoney& monToTest) const
{
    return (__f8Val < monToTest.__f8Val);
}

inline tCIDLib::TBoolean TMoney::operator<=(const TMoney& monToTest) const
{
    return (__f8Val <= monToTest.__f8Val);
}

inline tCIDLib::TBoolean TMoney::operator>(const TMoney& monToTest) const
{
    return (__f8Val > monToTest.__f8Val);
}

inline tCIDLib::TBoolean TMoney::operator>=(const TMoney& monToTest) const
{
    return (__f8Val >= monToTest.__f8Val);
}


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TFloat8 TMoney::f8Val() const
{
    return __f8Val;
}

inline tCIDLib::TFloat8 TMoney::f8Val(const tCIDLib::TFloat8 f8NewVal)
{
    __f8Val = f8NewVal;
    return __f8Val;
}
