//
// NAME: CIDLib_Module.Hpp
//
// DESCRIPTION:
//
//  This is the header file for the CIDLib_Module.Cpp module. This module
//  provides the basic TModule class, which represents a DLL or Exe module.
//  This class is the base class for the more important (and more often used)
//  TFacility class.
//
//  The only time this class is really used directly is during module init,
//  when an object of this type is passed to the module functions so that they
//  can do things like load strings before the facility object (a global
//  object) is constructed.
//
//  This class draws upon the TKrnlModule class, which provides the underlying
//  platform specific functionality.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/05/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class   TError;
class   TLogger;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TModule
// PREFIX: mod
// ----------------------------------------------------------------------------
class CIDLIBEXP TModule : public TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TModule
        (
            const   TString&                strName
            , const tCIDLib::EModTypes      eModType
            , const tCIDLib::TBoolean       bLoad = kCIDLib::False
        );

        TModule
        (
            const   tCIDLib::TModHandle     hmodToUse
            , const tCIDLib::EModTypes      eModType
            , const tCIDLib::EAdoptOpts     eAdopt = tCIDLib::EAdoptOpt_NoAdopt
            , const tCIDLib::TBoolean       bViaLoad = kCIDLib::False
        );

        ~TModule();


        // --------------------------------------------------------------------
        //  Public, static methods
        // --------------------------------------------------------------------
        static tCIDLib::TBoolean bLoadOSMsg
        (
            const   tCIDLib::TOSErrCode     errcId
            ,       TString&                strToFill
        );

        static tCIDLib::ESeverities eSevThreshold
        (
            const   tCIDLib::ESeverities    eSevToSet
        );

        static tCIDLib::ESeverities eSevThreshold();

        static tCIDLib::TVoid InstallLogger
        (
                    TLogger* const          plgrToAdopt
        );


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::EModTypes eModType() const;

        const TKrnlModule& kmodThis() const;

        tCIDLib::TVoid LoadCIDMsg
        (
            const   tCIDLib::TMsgId         midToLoad
            ,       TString&                strMsgBuf
        )   const;

        tCIDLib::TVoid LoadCIDMsg
        (
            const   tCIDLib::TMsgId         midToLoad
            ,       TString&                strMsgBuf
            , const MFormattable&           fmtblToken1
            , const MFormattable&           fmtblToken2   = NUL_MFormattable
            , const MFormattable&           fmtblToken3   = NUL_MFormattable
            , const MFormattable&           fmtblToken4   = NUL_MFormattable
        )   const;

        tCIDLib::TVoid LoadResString
        (
            const   tCIDLib::TResId         ridToLoad
            ,       TString&                strMsgBuf
        )   const;

        tCIDLib::TVoid LoadResString
        (
            const   tCIDLib::TResId         ridToLoad
            ,       TString&                strMsgBuf
            , const MFormattable&           fmtblToken1
            , const MFormattable&           fmtblToken2   = NUL_MFormattable
            , const MFormattable&           fmtblToken3   = NUL_MFormattable
            , const MFormattable&           fmtblToken4   = NUL_MFormattable
        )   const;

        tCIDLib::TVoid LogErr
        (
            const TString&                  strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToLog
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass = tCIDLib::EClass_Unknown
        )   const;

        tCIDLib::TVoid LogErr
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToLog
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass
            , const MFormattable&           fmtblToken1
            , const MFormattable&           fmtblToken2 = NUL_MFormattable
            , const MFormattable&           fmtblToken3 = NUL_MFormattable
            , const MFormattable&           fmtblToken4 = NUL_MFormattable
        )   const;

        tCIDLib::TVoid LogErr
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToLog
            , const TString&                strAuxText
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass = tCIDLib::EClass_Unknown
        )   const;

        tCIDLib::TVoid LogErr
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToLog
            , const TString&                strAuxText
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass
            , const MFormattable&           fmtblToken1
            , const MFormattable&           fmtblToken2 = NUL_MFormattable
            , const MFormattable&           fmtblToken3 = NUL_MFormattable
            , const MFormattable&           fmtblToken4 = NUL_MFormattable
        )   const;

        tCIDLib::TVoid LogErrObj
        (
            const   TError&                 errToLog
        )   const;

        tCIDLib::TVoid LogKrnlErr
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToLog
            , const TKrnlError&             kerrToLog
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass
        )   const;

        tCIDLib::TVoid LogKrnlErr
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToLog
            , const TKrnlError&             kerrToLog
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass
            , const MFormattable&           fmtblToken1
            , const MFormattable&           fmtblToken2 = NUL_MFormattable
            , const MFormattable&           fmtblToken3 = NUL_MFormattable
            , const MFormattable&           fmtblToken4 = NUL_MFormattable
        )   const;


        tCIDLib::TVoid LogMsg
        (
            const TString&                  strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const TString&                strMsg
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass = tCIDLib::EClass_AppStatus
        )   const;

        tCIDLib::TVoid LogMsg
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const TString&                strMsg
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass
            , const MFormattable&           fmtblToken1
            , const MFormattable&           fmtblToken2 = NUL_MFormattable
            , const MFormattable&           fmtblToken3 = NUL_MFormattable
            , const MFormattable&           fmtblToken4 = NUL_MFormattable
        )   const;

        const tCIDLib::Tch* pszLoadCIDMsg
        (
            const   tCIDLib::TMsgId         midToLoad
            ,       tCIDLib::TBoolean&      bLoaded = NUL_TBoolean
        )   const;

        const tCIDLib::Tch* pszLoadResString
        (
            const   tCIDLib::TResId         ridToLoad
            ,       tCIDLib::TBoolean&      bLoaded = NUL_TBoolean
        )   const;

        tCIDLib::TVoid QueryResourceSize
        (
            const   tCIDLib::ERscTypes      eRscType
            , const tCIDLib::TResId         ridToQuery
            ,       tCIDLib::TCard4&        c4Size
        )   const;

        TString strMsg
        (
            const   tCIDLib::TMsgId         midToLoad
        );

        TString strMsg
        (
            const   tCIDLib::TMsgId         midToLoad
            , const MFormattable&           fmtblToken1
            , const MFormattable&           fmtblToken2 = NUL_MFormattable
            , const MFormattable&           fmtblToken3 = NUL_MFormattable
            , const MFormattable&           fmtblToken4 = NUL_MFormattable
        );

        const TString& strName() const;

        tCIDLib::TVoid ThrowErr
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToThrow
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass = tCIDLib::EClass_Unknown
        )   const;

        tCIDLib::TVoid ThrowErr
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToThrow
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass
            , const MFormattable&           fmtblToken1
            , const MFormattable&           fmtblToken2 = NUL_MFormattable
            , const MFormattable&           fmtblToken3 = NUL_MFormattable
            , const MFormattable&           fmtblToken4 = NUL_MFormattable
        )   const;

        tCIDLib::TVoid ThrowErr
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToThrow
            , const TString&                strAuxText
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass = tCIDLib::EClass_Unknown
        )   const;

        tCIDLib::TVoid ThrowErr
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToThrow
            , const TString&                strAuxText
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass
            , const MFormattable&           fmtblToken1
            , const MFormattable&           fmtblToken2 = NUL_MFormattable
            , const MFormattable&           fmtblToken3 = NUL_MFormattable
            , const MFormattable&           fmtblToken4 = NUL_MFormattable
        )   const;

        tCIDLib::TVoid ThrowKrnlErr
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToThrow
            , const TKrnlError&             kerrToThrow
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass
        )   const;

        tCIDLib::TVoid ThrowKrnlErr
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::TErrCode       errcToThrow
            , const TKrnlError&             kerrToThrow
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass
            , const MFormattable&           fmtblToken1
            , const MFormattable&           fmtblToken2 = NUL_MFormattable
            , const MFormattable&           fmtblToken3 = NUL_MFormattable
            , const MFormattable&           fmtblToken4 = NUL_MFormattable
        )   const;

        tCIDLib::TVoid ThrowMsg
        (
            const TString&                  strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const TString&                strMsg
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass = tCIDLib::EClass_AppStatus
        )   const;

        tCIDLib::TVoid ThrowMsg
        (
            const   TString&                strFileName
            , const tCIDLib::TCard4         c4LineNum
            , const TString&                strMsg
            , const tCIDLib::ESeverities    eSeverity
            , const tCIDLib::EErrClasses    eClass
            , const MFormattable&           fmtblToken1
            , const MFormattable&           fmtblToken2 = NUL_MFormattable
            , const MFormattable&           fmtblToken3 = NUL_MFormattable
            , const MFormattable&           fmtblToken4 = NUL_MFormattable
        )   const;


    protected   :
        // --------------------------------------------------------------------
        //  Declare our friends
        // --------------------------------------------------------------------
        friend tCIDLib::TVoid _InitTermMod
        (
            const   tCIDLib::EInitTerm      eInitTerm
            , const tCIDLib::EGlobalStates  eGlobals
            , const TModule&                modInit
            , const tCIDLib::TCard4         c4MaxChars
            ,       tCIDLib::Tch* const     pszFailReason
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TModule();

        TModule(const TModule&);

        tCIDLib::TVoid operator=(const TModule&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __eModType
        //      The type of this facility, set during the constructor.
        //
        //  __kmodThis
        //      The facility module object. This is set by the constructor.
        //
        //  __strName
        //      The name of the facility, passed in the constructor and
        //      stored here.
        // --------------------------------------------------------------------
        tCIDLib::EModTypes      __eModType;
        TKrnlModule             __kmodThis;
        TString                 __strName;


        // --------------------------------------------------------------------
        //  Private, static data members
        //
        //  __eSevThreshold
        //      This is the logging threshold that indicates what errors will
        //      be logged and which eaten. Any log message that is of equal
        //      or greater severity will be passed on, others will be eaten.
        //
        //  __plgrTarget
        //      This is the target logger object. A default is installed by
        //      our module init, but is often overridden.
        //
        //  __pmtxLogSync
        //      This semaphore is used to keep multiple threads from logging
        //      messages at the same instant and intermingling their output.
        //      It is initialized by the module unit.
        // --------------------------------------------------------------------
        static  tCIDLib::ESeverities    __eSevThreshold;
        static  TLogger*                __plgrTarget;
        static  TMutex*                 __pmtxLogSync;


        // --------------------------------------------------------------------
        //  Magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TModule,TObject)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, static methods
// ----------------------------------------------------------------------------
inline tCIDLib::ESeverities TModule::eSevThreshold()
{
    return __eSevThreshold;
}


// ----------------------------------------------------------------------------
//  Public, non-virtual 
// ----------------------------------------------------------------------------
inline tCIDLib::EModTypes TModule::eModType() const
{
    return __eModType;
}

inline const TKrnlModule& TModule::kmodThis() const
{
    return __kmodThis;
}

inline const TString& TModule::strName() const
{
    return __strName;
}
