//
// NAME: CIDLib_Metrics.Hpp
//
// DESCRIPTION:
//
//	This is the header for the CIDLib_Metrics.Cpp module. This guy implements
//  the TMetricGroup and TMetricSystem classes, which allow programs to register
//  and manage their own metrics.
//
//  All subsystems can register groups of metrics with this system. These
//  metrics will then be made available via a shared memory area (the metrics
//  directory.) The memory is not available directly, only via the public API.
//  The metrics viewer/collector program understands the memory format and what
//  semaphore to lock before reading the memory.
//
//  TMetricGroup is the class that represents a group of metrics.
//  TMetricSystem is a class that provides access to the metrics system so
//  that groups can be registered. TMetricGroup objects cannot be created
//  directly, only via the TMetricSystem class.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 01/11/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class   TMetricSystem;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TMetricGroup
//  PREFIX: mtrg
// ----------------------------------------------------------------------------
class CIDLIBEXP TMetricGroup : public TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        ~TMetricGroup() {}


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid AddToAccum
        (
            const   tCIDLib::TCard4         c4MetricId
            , const tCIDLib::TCard4         c4Add
        );

        tCIDLib::TVoid FlipToggle
        (
            const   tCIDLib::TCard4         c4MetricId
        );

        tCIDLib::TVoid IncCounter
        (
            const   tCIDLib::TCard4         c4MetricId
        );

        tCIDLib::TVoid OffsetCard
        (
            const   tCIDLib::TCard4         c4MetricId
            , const tCIDLib::TInt4          i4Offset
        );

        tCIDLib::TVoid OffsetInt
        (
            const   tCIDLib::TCard4         c4MetricId
            , const tCIDLib::TInt4          i4Offset
        );

        tCIDLib::TVoid SetCard
        (
            const   tCIDLib::TCard4         c4MetricId
            , const tCIDLib::TCard4         c4NewValue
        );

        tCIDLib::TVoid SetFlag
        (
            const   tCIDLib::TCard4         c4MetricId
            , const tCIDLib::TCard4         c4BitNum
            , const tCIDLib::TBoolean       bNewState
        );

        tCIDLib::TVoid SetFlags
        (
            const   tCIDLib::TCard4         c4MetricId
            , const tCIDLib::TCard4         c4TargetMask
            , const tCIDLib::TCard4         c4ValueMask
        );

        tCIDLib::TVoid SetInt
        (
            const   tCIDLib::TCard4         c4MetricId
            , const tCIDLib::TInt4          i4NewValue
        );

        tCIDLib::TVoid SetPeak
        (
            const   tCIDLib::TCard4         c4MetricId
            , const tCIDLib::TCard4         c4NewValue
        );

        tCIDLib::TVoid SetToggle
        (
            const   tCIDLib::TCard4         c4MetricId
            , const tCIDLib::TBoolean       bNewValue
        );


    protected   :
        // --------------------------------------------------------------------
        //  Declare our friends
        // --------------------------------------------------------------------
        friend TMetricSystem;

        tCIDLib::TVoid _InitTermMetrics
        (
            const   tCIDLib::EInitTerm      eInitTerm
            , const tCIDLib::EGlobalStates  eGlobals
            , const TModule&                modInit
            , const tCIDLib::TCard4         c4MaxChars
            ,       tCIDLib::Tch* const     pszFailReason
        );


        // --------------------------------------------------------------------
        //  Hidden constructors and operators
        // --------------------------------------------------------------------
        TMetricGroup
        (
            const   tCIDLib::TCard4         c4Count
            ,       tCIDLib::TRawMetricGroup* const pmtrgData
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and opererators
        // --------------------------------------------------------------------
        TMetricGroup();

        TMetricGroup(const TMetricGroup&);

        tCIDLib::TVoid operator=(const TMetricGroup&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __c4MetricCount
        //      The number of metrics in this group. There is a maximum of
        //      tCIDLib::c4MaxMetricsPerGrp metrics in a single group. If
        //      this is exceeded, then a fatal error is issued.
        //
        //  __pkmtrgData
        //      This is a pointer to this group's data in the shared memory
        //      area. For fast access.
        // --------------------------------------------------------------------
        tCIDLib::TCard4             __c4MetricCount;
        tCIDLib::TRawMetricGroup*   __pmtrgData;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TMetricGroup,TObject)
};



// ----------------------------------------------------------------------------
//   CLASS: TMetricSystem
//  PREFIX: mtrsys
// ----------------------------------------------------------------------------
class CIDLIBEXP TMetricSystem : public TObject
{
    public  :
        // --------------------------------------------------------------------
        //  This is a small structure that is used by the client to register
        //  metrics groups. An array of these is used to provide the metrics
        //  info for the metrics to be in the new group.
        // --------------------------------------------------------------------
        struct TMetricInfo
        {
            tCIDLib::EMetricTypes   eType;
            TString                 strMetricName;
            TString                 strMetricHelp;
        };

        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TMetricSystem();

        ~TMetricSystem();


        // --------------------------------------------------------------------
        //  Public, static functions
        // --------------------------------------------------------------------
        static TMetricGroup* pmtrgRegisterGroup
        (
            const   TString&                strGroupName
            , const TString&                strGroupHelp
            , const TMetricInfo*            amtriList
            , const tCIDLib::TCard4         c4Count
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TMetricSystem(const TMetricSystem&);

        tCIDLib::TVoid operator=(const TMetricSystem&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TMetricSystem,TObject)
};

#pragma pack(pop)



// ----------------------------------------------------------------------------
//  Constructors and Destructors
// ----------------------------------------------------------------------------
inline TMetricSystem::TMetricSystem()
{
}

inline TMetricSystem::~TMetricSystem()
{
}
