//
// NAME: CIDLib_Logger.Hpp
//
// DESCRIPTION:
//
//  This is the header file for the CIDLib_Logger.Cpp module. This module
//  provides the abstraction of a destination for logged messages. The
//  base TFacility class does its logging via this abstract API.
//
//  Standard derivatives of this class are created to support logging to
//  various places. Higher level DLLs or Exes can override the default
//  logger in order to get control of logged messages, so they can be sent
//  to particular places.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/27/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//
//  1)  Calls to LogMsg() are synchronized internally, so it can use
//      static resources to do the formatting and logging. However, if
//      it logs to a target that is available to multiple processes, it
//      must provide its own synchronization.
//
//  2)  We don't have our own Cpp file so we put our RTTIData() macro
//      in CIDLib.Cpp
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TLogger
// PREFIX: lgr
// -----------------------------------------------------------------------------
class CIDLIBEXP TLogger : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        // ---------------------------------------------------------------------
        TLogger() {}

        ~TLogger() {}


        // ---------------------------------------------------------------------
        //  Public, virtual methods
        // ---------------------------------------------------------------------
        virtual tCIDLib::TVoid LogMsg
        (
            const   TError&                 errToLog
        ) = 0;


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TLogger(const TLogger&);

        tCIDLib::TVoid operator=(const TLogger&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TLogger,TObject)
};

#pragma pack(pop)
