//
// NAME: CIDLib_Lock.Hpp
//
// DESCRIPTION: 
//
//  This header defines a lock janitor class and the 'mixin' virtual class
//  that implements the interface it works in terms of. It will lock
//  anything that implements the MLockable interface.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 02/11/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//
//  1)  These classes are all inline, so any out of line RTTI macro stuff
//      needed by them are in CIDLib.Cpp.
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: MLockable
// PREFIX: lock
// -----------------------------------------------------------------------------
class CIDLIBEXP MLockable
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        // ---------------------------------------------------------------------
        ~MLockable() {}


        // ---------------------------------------------------------------------
        //  Public, pure virtual methods
        // ---------------------------------------------------------------------
        virtual tCIDLib::TVoid Lock
        (
            const   tCIDLib::TCard4         c4Timeout = kCIDLib::c4MaxWait
        )   const = 0;

        virtual tCIDLib::TVoid Unlock() const = 0;


    protected       :
        // ---------------------------------------------------------------------
        //  Hidden constructors and operators
        // ---------------------------------------------------------------------
        MLockable() {}


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        MLockable(const MLockable&);

        tCIDLib::TVoid operator=(const MLockable&);
};



// ----------------------------------------------------------------------------
//  CLASS: TLocker
// PREFIX: lock
// ----------------------------------------------------------------------------
class CIDLIBEXP TLocker : public TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TLocker
        (
                const   MLockable* const    pToLock
                , const tCIDLib::TCard4     c4Timeout = kCIDLib::c4MaxWait
        );

        ~TLocker();

    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TLocker();

        TLocker(const TLocker&);

        tCIDLib::TVoid operator=(const TLocker&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __pToLock
        //      This is a pointer to the target lockable object that we will
        //      release upon destruction.
        // --------------------------------------------------------------------
        const MLockable*    __pToLock;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TLocker,TObject)
};

#pragma pack(pop)


inline
TLocker::TLocker(   const   MLockable* const    pToLock
                    , const tCIDLib::TCard4     c4Timeout) :

    __pToLock(pToLock)
{
    __pToLock->Lock(c4Timeout);
}

inline TLocker::~TLocker()
{
    __pToLock->Unlock();
}
