//
// NAME: CIDLib_Locale.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDLib_Locale.Cpp module. This module implements
//  the TLocale class, which provides access to locale information needed to
//  adapt programs to local conventions. This class is really just a wrapper
//  for the kernel namespace, TKrnlLocale, which provides the real access to
//  system locale services.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/10/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//
//  1)  TKrnlLocale does not provide any thread safety, since it assumes
//      that it is being used by this class which provides it. So, don't
//      call any kernel locale APIs directly if there is any chance that
//      other threads might be using those APIs directly via this class!
//

#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TLocale
// PREFIX: loc
// -----------------------------------------------------------------------------
class CIDLIBEXP TLocale : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and operators
        // ---------------------------------------------------------------------
        TLocale();

        ~TLocale();


        // ---------------------------------------------------------------------
        //  Public, static methods
        // ---------------------------------------------------------------------
        static tCIDLib::TBoolean bNegSpacedSym();

        static tCIDLib::TBoolean bNegSymPrecedes();

        static tCIDLib::TBoolean bPosSpacedSym();

        static tCIDLib::TBoolean bPosSymPrecedes();

        static tCIDLib::TCard4 c4GroupSize();

        static tCIDLib::TCard4 c4MonetaryDecDigits();

        static tCIDLib::TCard4 c4MonetaryGrpSize();

        static tCIDLib::Tch chDecimalSym();

        static tCIDLib::Tch chThousandsSep();

        static tCIDLib::Tch chMonetaryDecimalSym();

        static tCIDLib::Tch chMonetaryGrpSep();

        static tCIDLib::Tch chCurrencySymbol();

        static tCIDLib::Tch chPosSign();

        static tCIDLib::Tch chNegSign();

        static tCIDLib::ESignPositions eNegSignPosition();

        static tCIDLib::ESignPositions ePosSignPosition();

        static TString strLocale();

        static tCIDLib::TVoid SetLocale
        (
            const   TString&                strLocale
        );


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TLocale(const TLocale&);

        tCIDLib::TVoid operator=(const TLocale&);


        // ---------------------------------------------------------------------
        //  Do any needed macros
        // ---------------------------------------------------------------------
        RTTIMacros(TLocale,TObject)
};

#pragma pack(pop)



// -----------------------------------------------------------------------------
//  Constructors and destructors
// -----------------------------------------------------------------------------
inline TLocale::TLocale()
{
}

inline TLocale::~TLocale()
{
}
