//
// NAME: CIDLib_Integer.Hpp
//
// DESCRIPTION:
//
//  This is the definition file for the CIDLib_Integer.Cpp module. This module
//  implements a class wrapper for a 32 bit signed integer. Its a very
//  simple class and makes no attempt to create a fully mathematical
//  functional class. Its purely for formatting purposes and for when an
//  integer needs to act like an object.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 04/15/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class   TCardinal;
class   TFloat;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TInteger
// PREFIX: i
// ----------------------------------------------------------------------------
class CIDLIBEXP TInteger :

    public TObject, public MFormattable, public MDuplicable, public MStreamable
{
    public  :
        // --------------------------------------------------------------------
        // Constructors and Destructors
        // --------------------------------------------------------------------
        TInteger();

        TInteger
        (
            const   tCIDLib::TInt4          i4Val
            , const tCIDLib::ERadices       eRadix = tCIDLib::ERadix_Dec
        );

        TInteger
        (
            const   TInteger&               iToCopy
        );

        ~TInteger();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        operator tCIDLib::TInt4() const;

        TInteger& operator=
        (
            const   tCIDLib::TInt4          i4NewVal
        );

        TInteger& operator=
        (
            const   TInteger&               iToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TInteger&               iToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TInteger&               iToTest
        )   const;

        tCIDLib::TBoolean operator==
        (
            const   tCIDLib::TInt4          i4ToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   tCIDLib::TInt4          i4ToTest
        )   const;

        tCIDLib::TBoolean operator<
        (
            const   TInteger&               iToTest
        )   const;

        tCIDLib::TBoolean operator<=
        (
            const   TInteger&               iToTest
        )   const;

        tCIDLib::TBoolean operator>
        (
            const   TInteger&               iToTest
        )   const;

        tCIDLib::TBoolean operator>=
        (
            const   TInteger&               iToTest
        )   const;


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TInt4 i4Val() const;

        tCIDLib::TInt4 i4Val
        (
            const   tCIDLib::TInt4          i4NewVal
        );

        tCIDLib::ERadices eRadix() const;

        tCIDLib::ERadices eRadix
        (
            const   tCIDLib::ERadices       eNewRadix
        );


    protected   :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmDest
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&             strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&             strmToWriteTo
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __i4Val
        //      Storage for the data value
        //
        //  __eRadix
        //      The display radix for the value
        // --------------------------------------------------------------------
        tCIDLib::TInt4          __i4Val;
        tCIDLib::ERadices       __eRadix;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TInteger,TObject)
        DefPolyDup(TInteger)
};



// ----------------------------------------------------------------------------
//  CLASS: TLocInteger
// PREFIX: i
// ----------------------------------------------------------------------------
class CIDLIBEXP TLocInteger : public TInteger
{
    public  :
        // --------------------------------------------------------------------
        // Constructors and Destructors
        // --------------------------------------------------------------------
        TLocInteger();

        TLocInteger
        (
            const   tCIDLib::TInt4          i4Val
        );

        TLocInteger
        (
            const   TLocInteger&            iToCopy
        );

        ~TLocInteger();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        operator tCIDLib::TInt4() const;

        TLocInteger& operator=
        (
            const   TLocInteger&            iToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TLocInteger&            iToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TLocInteger&            iToTest
        )   const;

        tCIDLib::TBoolean operator<
        (
            const   TLocInteger&            iToTest
        )   const;

        tCIDLib::TBoolean operator<=
        (
            const   TLocInteger&            iToTest
        )   const;

        tCIDLib::TBoolean operator>
        (
            const   TLocInteger&            iToTest
        )   const;

        tCIDLib::TBoolean operator>=
        (
            const   TLocInteger&            iToTest
        )   const;


    protected   :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmDest
        )   const;

    private :
        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TLocInteger,TInteger)
        DefPolyDup(TLocInteger)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  TInteger: Constructors and destrutors
// ----------------------------------------------------------------------------
inline TInteger::~TInteger()
{
}

// ----------------------------------------------------------------------------
//  TInteger: Public operators
// ----------------------------------------------------------------------------
inline TInteger::operator tCIDLib::TInt4() const
{
    return __i4Val;
}

inline TInteger& TInteger::operator=(const tCIDLib::TInt4 i4NewVal)
{
    __i4Val = i4NewVal;
    return *this;
}

inline tCIDLib::TBoolean TInteger::operator!=(const TInteger& iToTest) const
{
    return !operator==(iToTest);
}

inline tCIDLib::TBoolean TInteger::operator==(const tCIDLib::TInt4 i4ToTest) const
{
    return (i4ToTest == __i4Val);
}

inline tCIDLib::TBoolean TInteger::operator!=(const tCIDLib::TInt4 i4ToTest) const
{
    return (i4ToTest != __i4Val);
}

inline tCIDLib::TBoolean TInteger::operator<(const TInteger& cComp) const
{
    return (__i4Val < cComp.__i4Val);
}

inline tCIDLib::TBoolean TInteger::operator<=(const TInteger& cComp) const
{
    return (__i4Val <= cComp.__i4Val);
}

inline tCIDLib::TBoolean TInteger::operator>(const TInteger& cComp) const
{
    return (__i4Val > cComp.__i4Val);
}

inline tCIDLib::TBoolean TInteger::operator>=(const TInteger& cComp) const
{
    return (__i4Val >= cComp.__i4Val);
}


// ----------------------------------------------------------------------------
//  TInteger: Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TInt4 TInteger::i4Val() const
{
    return __i4Val;
}

inline tCIDLib::TInt4 TInteger::i4Val(const tCIDLib::TInt4 i4NewVal)
{
    __i4Val = i4NewVal;
    return __i4Val;
}

inline tCIDLib::ERadices TInteger::eRadix() const
{
    return __eRadix;
}

inline tCIDLib::ERadices
TInteger::eRadix(const tCIDLib::ERadices eNewRadix)
{
    __eRadix = eNewRadix;
    return __eRadix;
}


// ----------------------------------------------------------------------------
//  TLocInteger: Constructors and Destructors
// ----------------------------------------------------------------------------
inline TLocInteger::TLocInteger()
{
}

inline TLocInteger::TLocInteger(const tCIDLib::TInt4 i4Val) :

    TInteger(i4Val, tCIDLib::ERadix_Dec)
{
}

inline TLocInteger::TLocInteger(const TLocInteger& iToCopy) :

    TInteger(iToCopy)
{
}

inline TLocInteger::~TLocInteger()
{
}


// ----------------------------------------------------------------------------
//  TLocInteger: Assignement operators
// ----------------------------------------------------------------------------
inline TLocInteger& TLocInteger::operator=(const TLocInteger& iToAssign)
{
    TParent::operator=(iToAssign);
    return *this;
}

inline tCIDLib::TBoolean
TLocInteger::operator==(const TLocInteger& iToTest) const
{
    return TParent::operator==(iToTest);
}

inline tCIDLib::TBoolean
TLocInteger::operator!=(const TLocInteger& iToTest) const
{
    return !TParent::operator==(iToTest);
}

inline tCIDLib::TBoolean TLocInteger::operator<(const TLocInteger& cComp) const
{
    return TParent::operator<(cComp);
}

inline tCIDLib::TBoolean TLocInteger::operator<=(const TLocInteger& cComp) const
{
    return TParent::operator<=(cComp);
}

inline tCIDLib::TBoolean TLocInteger::operator>(const TLocInteger& cComp) const
{
    return TParent::operator>(cComp);
}

inline tCIDLib::TBoolean TLocInteger::operator>=(const TLocInteger& cComp) const
{
    return TParent::operator>=(cComp);
}
